import _orderBy from "lodash/orderBy";
import _isPlainObject from "lodash/isPlainObject";
import _uniqueId from "lodash/uniqueId";
import _defaults from "lodash/defaults";
import _assign from "lodash/assign";

function _toConsumableArray(arr) { return _arrayWithoutHoles(arr) || _iterableToArray(arr) || _nonIterableSpread(); }

function _nonIterableSpread() { throw new TypeError("Invalid attempt to spread non-iterable instance"); }

function _iterableToArray(iter) { if (Symbol.iterator in Object(iter) || Object.prototype.toString.call(iter) === "[object Arguments]") return Array.from(iter); }

function _arrayWithoutHoles(arr) { if (Array.isArray(arr)) { for (var i = 0, arr2 = new Array(arr.length); i < arr.length; i++) { arr2[i] = arr[i]; } return arr2; } }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } }

function _createClass(Constructor, protoProps, staticProps) { if (protoProps) _defineProperties(Constructor.prototype, protoProps); if (staticProps) _defineProperties(Constructor, staticProps); return Constructor; }

function _possibleConstructorReturn(self, call) { if (call && (typeof call === "object" || typeof call === "function")) { return call; } return _assertThisInitialized(self); }

function _assertThisInitialized(self) { if (self === void 0) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return self; }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function"); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, enumerable: false, writable: true, configurable: true } }); if (superClass) Object.setPrototypeOf ? Object.setPrototypeOf(subClass, superClass) : subClass.__proto__ = superClass; }

import React from "react";
import PropTypes from "prop-types";
import { PropTypes as CustomPropTypes, TextSize, Helpers, LabelHelpers, VictoryLabel, VictoryTheme, VictoryPortal } from "victory-core";
import Flyout from "./flyout";
var fallbackProps = {
  cornerRadius: 5,
  pointerLength: 10,
  pointerWidth: 10
};

var VictoryTooltip =
/*#__PURE__*/
function (_React$Component) {
  _inherits(VictoryTooltip, _React$Component);

  function VictoryTooltip(props) {
    var _this;

    _classCallCheck(this, VictoryTooltip);

    _this = _possibleConstructorReturn(this, (VictoryTooltip.__proto__ || Object.getPrototypeOf(VictoryTooltip)).call(this, props));
    _this.id = props.id === undefined ? _uniqueId("tooltip-") : props.id;
    return _this;
  }

  _createClass(VictoryTooltip, [{
    key: "getDefaultOrientation",
    value: function getDefaultOrientation(props) {
      var datum = props.datum,
          horizontal = props.horizontal,
          polar = props.polar;

      if (!polar) {
        var positive = horizontal ? "right" : "top";
        var negative = horizontal ? "left" : "bottom";
        return datum && datum.y < 0 ? negative : positive;
      } else {
        return this.getPolarOrientation(props, datum);
      }
    }
  }, {
    key: "getPolarOrientation",
    value: function getPolarOrientation(props, datum) {
      var degrees = LabelHelpers.getDegrees(props, datum);
      var placement = props.labelPlacement || "vertical";

      if (placement === " vertical") {
        return this.getVerticalOrientations(degrees);
      } else if (placement === "parallel") {
        return degrees < 90 || degrees > 270 ? "right" : "left";
      } else {
        return degrees > 180 ? "bottom" : "top";
      }
    }
  }, {
    key: "getVerticalOrientations",
    value: function getVerticalOrientations(degrees) {
      // eslint-disable-next-line no-magic-numbers
      if (degrees < 45 || degrees > 315) {
        return "right"; // eslint-disable-next-line no-magic-numbers
      } else if (degrees >= 45 && degrees <= 135) {
        return "top"; // eslint-disable-next-line no-magic-numbers
      } else if (degrees > 135 && degrees < 225) {
        return "left";
      } else {
        return "bottom";
      }
    }
  }, {
    key: "getStyles",
    value: function getStyles(props) {
      var theme = props.theme || VictoryTheme.grayscale;
      var defaultLabelStyles = theme && theme.tooltip && theme.tooltip.style ? theme.tooltip.style : {};
      var baseLabelStyle = Array.isArray(props.style) ? props.style.map(function (s) {
        return _defaults({}, s, defaultLabelStyles);
      }) : _defaults({}, props.style, defaultLabelStyles);
      var defaultFlyoutStyles = theme && theme.tooltip && theme.tooltip.flyoutStyle ? theme.tooltip.flyoutStyle : {};
      var baseFlyoutStyle = props.flyoutStyle ? _defaults({}, props.flyoutStyle, defaultFlyoutStyles) : defaultFlyoutStyles;
      var style = Array.isArray(baseLabelStyle) ? baseLabelStyle.map(function (s) {
        return Helpers.evaluateStyle(s, props);
      }) : Helpers.evaluateStyle(baseLabelStyle, props);
      var flyoutStyle = Helpers.evaluateStyle(baseFlyoutStyle, _assign({}, props, {
        style: style
      }));
      return {
        style: style,
        flyoutStyle: flyoutStyle
      };
    }
  }, {
    key: "getEvaluatedProps",
    value: function getEvaluatedProps(props) {
      var cornerRadius = props.cornerRadius,
          centerOffset = props.centerOffset,
          dx = props.dx,
          dy = props.dy;
      var active = Helpers.evaluateProp(props.active, props);
      var text = Helpers.evaluateProp(props.text, _assign({}, props, {
        active: active
      }));

      var _getStyles = this.getStyles(_assign({}, props, {
        active: active,
        text: text
      })),
          style = _getStyles.style,
          flyoutStyle = _getStyles.flyoutStyle;

      var orientation = Helpers.evaluateProp(props.orientation, _assign({}, props, {
        active: active,
        text: text,
        style: style,
        flyoutStyle: flyoutStyle
      })) || this.getDefaultOrientation(props);
      var padding = Helpers.evaluateProp(props.flyoutPadding, _assign({}, props, {
        active: active,
        text: text,
        style: style,
        flyoutStyle: flyoutStyle,
        orientation: orientation
      })) || this.getLabelPadding(style);
      var flyoutPadding = Helpers.getPadding({
        padding: padding
      });
      var pointerWidth = Helpers.evaluateProp(props.pointerWidth, _assign({}, props, {
        active: active,
        text: text,
        style: style,
        flyoutStyle: flyoutStyle,
        orientation: orientation
      }));
      var pointerLength = Helpers.evaluateProp(props.pointerLength, _assign({}, props, {
        active: active,
        text: text,
        style: style,
        flyoutStyle: flyoutStyle,
        orientation: orientation
      }));
      var labelSize = TextSize.approximateTextSize(text, style);

      var _getDimensions = this.getDimensions(_assign({}, props, {
        style: style,
        flyoutStyle: flyoutStyle,
        active: active,
        text: text,
        orientation: orientation,
        flyoutPadding: flyoutPadding,
        pointerWidth: pointerWidth,
        pointerLength: pointerLength
      }), labelSize),
          flyoutHeight = _getDimensions.flyoutHeight,
          flyoutWidth = _getDimensions.flyoutWidth;

      var evaluatedProps = _assign({}, props, {
        active: active,
        text: text,
        style: style,
        flyoutStyle: flyoutStyle,
        orientation: orientation,
        flyoutHeight: flyoutHeight,
        flyoutWidth: flyoutWidth,
        flyoutPadding: flyoutPadding,
        pointerWidth: pointerWidth,
        pointerLength: pointerLength
      });

      var offsetX = _isPlainObject(centerOffset) && centerOffset.x !== undefined ? Helpers.evaluateProp(centerOffset.x, evaluatedProps) : 0;
      var offsetY = _isPlainObject(centerOffset) && centerOffset.y !== undefined ? Helpers.evaluateProp(centerOffset.y, evaluatedProps) : 0;
      return _assign({}, evaluatedProps, {
        centerOffset: {
          x: offsetX,
          y: offsetY
        },
        dx: dx !== undefined ? Helpers.evaluateProp(dx, evaluatedProps) : 0,
        dy: dy !== undefined ? Helpers.evaluateProp(dy, evaluatedProps) : 0,
        cornerRadius: Helpers.evaluateProp(cornerRadius, evaluatedProps)
      });
    }
  }, {
    key: "getCalculatedValues",
    value: function getCalculatedValues(props) {
      var style = props.style,
          text = props.text,
          flyoutStyle = props.flyoutStyle,
          flyoutHeight = props.flyoutHeight,
          flyoutWidth = props.flyoutWidth;
      var labelSize = TextSize.approximateTextSize(text, style);
      var flyoutDimensions = {
        height: flyoutHeight,
        width: flyoutWidth
      };
      var flyoutCenter = this.getFlyoutCenter(props, flyoutDimensions);
      var transform = this.getTransform(props);
      return {
        style: style,
        flyoutStyle: flyoutStyle,
        labelSize: labelSize,
        flyoutDimensions: flyoutDimensions,
        flyoutCenter: flyoutCenter,
        transform: transform
      };
    }
  }, {
    key: "getTransform",
    value: function getTransform(props) {
      var x = props.x,
          y = props.y,
          style = props.style;
      var labelStyle = style || {};
      var angle = labelStyle.angle || props.angle || this.getDefaultAngle(props);
      return angle ? "rotate(".concat(angle, " ").concat(x, " ").concat(y, ")") : undefined;
    } // eslint-disable-next-line complexity

  }, {
    key: "getDefaultAngle",
    value: function getDefaultAngle(props) {
      var polar = props.polar,
          labelPlacement = props.labelPlacement,
          orientation = props.orientation,
          datum = props.datum;

      if (!polar || !labelPlacement || labelPlacement === "vertical") {
        return 0;
      }

      var degrees = LabelHelpers.getDegrees(props, datum);
      var sign = degrees > 90 && degrees < 180 || degrees > 270 ? 1 : -1;
      var labelRotation = labelPlacement === "perpendicular" ? 0 : 90;
      var angle;

      if (degrees === 0 || degrees === 180) {
        angle = orientation === "top" && degrees === 180 ? 270 : 90;
      } else if (degrees > 0 && degrees < 180) {
        angle = 90 - degrees;
      } else if (degrees > 180 && degrees < 360) {
        angle = 270 - degrees;
      }

      return angle + sign * labelRotation;
    }
  }, {
    key: "constrainTooltip",
    value: function constrainTooltip(center, props, dimensions) {
      var x = center.x,
          y = center.y;
      var width = dimensions.width,
          height = dimensions.height;
      var extent = {
        x: [0, props.width],
        y: [0, props.height]
      };
      var flyoutExtent = {
        x: [x - width / 2, x + width / 2],
        y: [y - height / 2, y + height / 2]
      };
      var adjustments = {
        x: [flyoutExtent.x[0] < extent.x[0] ? extent.x[0] - flyoutExtent.x[0] : 0, flyoutExtent.x[1] > extent.x[1] ? flyoutExtent.x[1] - extent.x[1] : 0],
        y: [flyoutExtent.y[0] < extent.y[0] ? extent.y[0] - flyoutExtent.y[0] : 0, flyoutExtent.y[1] > extent.y[1] ? flyoutExtent.y[1] - extent.y[1] : 0]
      };
      return {
        x: Math.round(x + adjustments.x[0] - adjustments.x[1]),
        y: Math.round(y + adjustments.y[0] - adjustments.y[1])
      };
    } // eslint-disable-next-line complexity

  }, {
    key: "getFlyoutCenter",
    value: function getFlyoutCenter(props, dimensions) {
      var x = props.x,
          y = props.y,
          dx = props.dx,
          dy = props.dy,
          pointerLength = props.pointerLength,
          orientation = props.orientation,
          constrainToVisibleArea = props.constrainToVisibleArea,
          centerOffset = props.centerOffset;
      var height = dimensions.height,
          width = dimensions.width;
      var xSign = orientation === "left" ? -1 : 1;
      var ySign = orientation === "bottom" ? -1 : 1;
      var flyoutCenter = {
        x: orientation === "left" || orientation === "right" ? x + xSign * (pointerLength + width / 2 + xSign * dx) : x + dx,
        y: orientation === "top" || orientation === "bottom" ? y - ySign * (pointerLength + height / 2 - ySign * dy) : y + dy
      };
      var center = {
        x: _isPlainObject(props.center) && props.center.x !== undefined ? props.center.x : flyoutCenter.x,
        y: _isPlainObject(props.center) && props.center.y !== undefined ? props.center.y : flyoutCenter.y
      };
      var centerWithOffset = {
        x: center.x + centerOffset.x,
        y: center.y + centerOffset.y
      };
      return constrainToVisibleArea ? this.constrainTooltip(centerWithOffset, props, dimensions) : centerWithOffset;
    }
  }, {
    key: "getLabelPadding",
    value: function getLabelPadding(style) {
      if (!style) {
        return 0;
      }

      var paddings = Array.isArray(style) ? style.map(function (s) {
        return s.padding;
      }) : [style.padding];
      return Math.max.apply(Math, _toConsumableArray(paddings).concat([0]));
    }
  }, {
    key: "getDimensions",
    value: function getDimensions(props, labelSize) {
      var orientation = props.orientation,
          pointerLength = props.pointerLength,
          pointerWidth = props.pointerWidth,
          flyoutHeight = props.flyoutHeight,
          flyoutWidth = props.flyoutWidth,
          flyoutPadding = props.flyoutPadding;
      var cornerRadius = Helpers.evaluateProp(props.cornerRadius, props);

      var getHeight = function () {
        var calculatedHeight = labelSize.height + flyoutPadding.top + flyoutPadding.bottom;
        var minHeight = orientation === "top" || orientation === "bottom" ? 2 * cornerRadius : 2 * cornerRadius + pointerWidth;
        return Math.max(minHeight, calculatedHeight);
      };

      var getWidth = function () {
        var calculatedWidth = labelSize.width + flyoutPadding.left + flyoutPadding.right;
        var minWidth = orientation === "left" || orientation === "right" ? 2 * cornerRadius + pointerLength : 2 * cornerRadius;
        return Math.max(minWidth, calculatedWidth);
      };

      return {
        flyoutHeight: flyoutHeight ? Helpers.evaluateProp(flyoutHeight, props) : getHeight(props, labelSize, orientation),
        flyoutWidth: flyoutWidth ? Helpers.evaluateProp(flyoutWidth, props) : getWidth(props, labelSize, orientation)
      };
    }
  }, {
    key: "getLabelProps",
    value: function getLabelProps(props, calculatedValues) {
      var flyoutCenter = calculatedValues.flyoutCenter,
          style = calculatedValues.style,
          labelSize = calculatedValues.labelSize,
          _calculatedValues$dy = calculatedValues.dy,
          dy = _calculatedValues$dy === void 0 ? 0 : _calculatedValues$dy,
          _calculatedValues$dx = calculatedValues.dx,
          dx = _calculatedValues$dx === void 0 ? 0 : _calculatedValues$dx;
      var text = props.text,
          datum = props.datum,
          activePoints = props.activePoints,
          labelComponent = props.labelComponent,
          index = props.index,
          flyoutPadding = props.flyoutPadding;
      var textAnchor = (Array.isArray(style) && style.length ? style[0].textAnchor : style.textAnchor) || "middle";

      var getLabelX = function () {
        if (!textAnchor || textAnchor === "middle") {
          return flyoutCenter.x;
        }

        var sign = textAnchor === "end" ? -1 : 1;
        return flyoutCenter.x - sign * (labelSize.width / 2);
      };

      return _defaults({}, labelComponent.props, {
        key: "".concat(this.id, "-label-").concat(index),
        text: text,
        datum: datum,
        activePoints: activePoints,
        textAnchor: textAnchor,
        dy: dy,
        dx: dx,
        style: style,
        x: getLabelX() + (flyoutPadding.left - flyoutPadding.right) / 2,
        y: flyoutCenter.y + (flyoutPadding.top - flyoutPadding.bottom) / 2,
        verticalAnchor: "middle",
        angle: style.angle
      });
    }
  }, {
    key: "getPointerOrientation",
    value: function getPointerOrientation(point, center, flyoutDimensions) {
      var edges = {
        bottom: center.y + flyoutDimensions.height / 2,
        top: center.y - flyoutDimensions.height / 2,
        left: center.x - flyoutDimensions.width / 2,
        right: center.x + flyoutDimensions.width / 2
      };
      var gaps = [{
        side: "top",
        val: edges.top > point.y ? edges.top - point.y : -1
      }, {
        side: "bottom",
        val: edges.bottom < point.y ? point.y - edges.bottom : -1
      }, {
        side: "right",
        val: edges.right < point.x ? point.x - edges.right : -1
      }, {
        side: "left",
        val: edges.left > point.x ? edges.left - point.x : -1
      }];
      return _orderBy(gaps, "val", "desc")[0].side;
    }
  }, {
    key: "getFlyoutProps",
    value: function getFlyoutProps(props, calculatedValues) {
      var flyoutDimensions = calculatedValues.flyoutDimensions,
          flyoutStyle = calculatedValues.flyoutStyle,
          flyoutCenter = calculatedValues.flyoutCenter;
      var x = props.x,
          y = props.y,
          dx = props.dx,
          dy = props.dy,
          datum = props.datum,
          activePoints = props.activePoints,
          index = props.index,
          pointerLength = props.pointerLength,
          pointerWidth = props.pointerWidth,
          cornerRadius = props.cornerRadius,
          events = props.events,
          flyoutComponent = props.flyoutComponent;
      var pointerOrientation = Helpers.evaluateProp(props.pointerOrientation, props);
      return _defaults({}, flyoutComponent.props, {
        x: x,
        y: y,
        dx: dx,
        dy: dy,
        datum: datum,
        activePoints: activePoints,
        index: index,
        pointerLength: pointerLength,
        pointerWidth: pointerWidth,
        cornerRadius: cornerRadius,
        events: events,
        orientation: pointerOrientation || this.getPointerOrientation({
          x: x,
          y: y
        }, flyoutCenter, flyoutDimensions),
        key: "".concat(this.id, "-tooltip-").concat(index),
        width: flyoutDimensions.width,
        height: flyoutDimensions.height,
        style: flyoutStyle,
        center: flyoutCenter
      });
    } // Overridden in victory-core-native

  }, {
    key: "renderTooltip",
    value: function renderTooltip(props) {
      var active = Helpers.evaluateProp(props.active, props);
      var renderInPortal = props.renderInPortal;

      if (!active) {
        return renderInPortal ? React.createElement(VictoryPortal, null, null) : null;
      }

      var evaluatedProps = this.getEvaluatedProps(props);
      var flyoutComponent = evaluatedProps.flyoutComponent,
          labelComponent = evaluatedProps.labelComponent,
          groupComponent = evaluatedProps.groupComponent;
      var calculatedValues = this.getCalculatedValues(evaluatedProps);
      var children = [React.cloneElement(flyoutComponent, this.getFlyoutProps(evaluatedProps, calculatedValues)), React.cloneElement(labelComponent, this.getLabelProps(evaluatedProps, calculatedValues))];
      var tooltip = React.cloneElement(groupComponent, {
        role: "presentation",
        transform: calculatedValues.transform
      }, children);
      return renderInPortal ? React.createElement(VictoryPortal, null, tooltip) : tooltip;
    }
  }, {
    key: "render",
    value: function render() {
      var props = Helpers.modifyProps(this.props, fallbackProps, "tooltip");
      return this.renderTooltip(props);
    }
  }]);

  return VictoryTooltip;
}(React.Component);

Object.defineProperty(VictoryTooltip, "displayName", {
  configurable: true,
  enumerable: true,
  writable: true,
  value: "VictoryTooltip"
});
Object.defineProperty(VictoryTooltip, "role", {
  configurable: true,
  enumerable: true,
  writable: true,
  value: "tooltip"
});
Object.defineProperty(VictoryTooltip, "propTypes", {
  configurable: true,
  enumerable: true,
  writable: true,
  value: {
    activateData: PropTypes.bool,
    active: PropTypes.oneOfType([PropTypes.bool, PropTypes.func]),
    activePoints: PropTypes.array,
    angle: PropTypes.number,
    center: PropTypes.shape({
      x: CustomPropTypes.nonNegative,
      y: CustomPropTypes.nonNegative
    }),
    centerOffset: PropTypes.shape({
      x: PropTypes.oneOfType([PropTypes.number, PropTypes.func]),
      y: PropTypes.oneOfType([PropTypes.number, PropTypes.func])
    }),
    constrainToVisibleArea: PropTypes.bool,
    cornerRadius: PropTypes.oneOfType([CustomPropTypes.nonNegative, PropTypes.func]),
    data: PropTypes.array,
    datum: PropTypes.object,
    dx: PropTypes.oneOfType([PropTypes.number, PropTypes.func]),
    dy: PropTypes.oneOfType([PropTypes.number, PropTypes.func]),
    events: PropTypes.object,
    flyoutComponent: PropTypes.element,
    flyoutHeight: PropTypes.oneOfType([CustomPropTypes.nonNegative, PropTypes.func]),
    flyoutPadding: PropTypes.oneOfType([PropTypes.func, PropTypes.number, PropTypes.shape({
      top: PropTypes.number,
      bottom: PropTypes.number,
      left: PropTypes.number,
      right: PropTypes.number
    })]),
    flyoutStyle: PropTypes.object,
    flyoutWidth: PropTypes.oneOfType([CustomPropTypes.nonNegative, PropTypes.func]),
    groupComponent: PropTypes.element,
    height: PropTypes.number,
    horizontal: PropTypes.bool,
    id: PropTypes.oneOfType([PropTypes.number, PropTypes.string]),
    index: PropTypes.oneOfType([PropTypes.number, PropTypes.string]),
    labelComponent: PropTypes.element,
    orientation: PropTypes.oneOfType([PropTypes.oneOf(["top", "bottom", "left", "right"]), PropTypes.func]),
    pointerLength: PropTypes.oneOfType([CustomPropTypes.nonNegative, PropTypes.func]),
    pointerOrientation: PropTypes.oneOfType([PropTypes.oneOf(["top", "bottom", "left", "right"]), PropTypes.func]),
    pointerWidth: PropTypes.oneOfType([CustomPropTypes.nonNegative, PropTypes.func]),
    polar: PropTypes.bool,
    renderInPortal: PropTypes.bool,
    scale: PropTypes.shape({
      x: CustomPropTypes.scale,
      y: CustomPropTypes.scale
    }),
    style: PropTypes.oneOfType([PropTypes.object, PropTypes.array]),
    text: PropTypes.oneOfType([PropTypes.string, PropTypes.number, PropTypes.func, PropTypes.array]),
    theme: PropTypes.object,
    width: PropTypes.number,
    x: PropTypes.number,
    y: PropTypes.number
  }
});
Object.defineProperty(VictoryTooltip, "defaultProps", {
  configurable: true,
  enumerable: true,
  writable: true,
  value: {
    active: false,
    renderInPortal: true,
    labelComponent: React.createElement(VictoryLabel, null),
    flyoutComponent: React.createElement(Flyout, null),
    groupComponent: React.createElement("g", null)
  }
});
Object.defineProperty(VictoryTooltip, "defaultEvents", {
  configurable: true,
  enumerable: true,
  writable: true,
  value: function (props) {
    var activate = props.activateData ? [{
      target: "labels",
      mutation: function () {
        return {
          active: true
        };
      }
    }, {
      target: "data",
      mutation: function () {
        return {
          active: true
        };
      }
    }] : [{
      target: "labels",
      mutation: function () {
        return {
          active: true
        };
      }
    }];
    var deactivate = props.activateData ? [{
      target: "labels",
      mutation: function () {
        return {
          active: undefined
        };
      }
    }, {
      target: "data",
      mutation: function () {
        return {
          active: undefined
        };
      }
    }] : [{
      target: "labels",
      mutation: function () {
        return {
          active: undefined
        };
      }
    }];
    return [{
      target: "data",
      eventHandlers: {
        onMouseOver: function () {
          return activate;
        },
        onFocus: function () {
          return activate;
        },
        onTouchStart: function () {
          return activate;
        },
        onMouseOut: function () {
          return deactivate;
        },
        onBlur: function () {
          return deactivate;
        },
        onTouchEnd: function () {
          return deactivate;
        }
      }
    }];
  }
});
export { VictoryTooltip as default };