export declare const GLOBAL_NAMESPACE = "__scalprum__";
export interface AppMetadata {
    name: string;
    appId?: string;
    elementId?: string;
    rootLocation?: string;
    scriptLocation?: string;
    manifestLocation?: string;
}
export interface AppsConfig {
    [key: string]: AppMetadata;
}
export interface Factory {
    init: (sharing: any) => void;
    modules: {
        [key: string]: any;
    };
    expiration: Date;
}
export interface ScalprumOptions {
    cacheTimeout: number;
}
export declare type Scalprum<T = any> = T & {
    appsConfig: AppsConfig;
    pendingInjections: {
        [key: string]: () => void;
    };
    factories: {
        [key: string]: Factory;
    };
    scalprumOptions: ScalprumOptions;
};
export declare type Container = Window & Factory;
export interface IModule {
    default: any;
}
declare global {
    interface Window {
        [GLOBAL_NAMESPACE]: Scalprum;
    }
}
export declare const getScalprum: <T = Record<string, unknown>>() => Scalprum<T>;
export declare const getCachedModule: (scope: string, module: string, skipCache?: boolean) => any | undefined;
export declare const setPendingInjection: (id: string, callback: () => void) => void;
export declare const initialize: <T = unknown>({ appsConfig, api, options, }: {
    appsConfig: AppsConfig;
    api?: T | undefined;
    options?: Partial<ScalprumOptions> | undefined;
}) => void;
export declare const getAppData: (name: string) => AppMetadata;
export declare const injectScript: (appName: string, scriptLocation: string, skipPending?: boolean | undefined) => Promise<[unknown, HTMLScriptElement | undefined]>;
export declare function processManifest(url: string, appName: string, scope: string, processor: ((value: any) => string) | undefined): Promise<[unknown, HTMLScriptElement | undefined][]>;
export declare function asyncLoader(scope: string, module: string): Promise<IModule>;
