import React from 'react';
import { EmptyState, EmptyStateIcon, EmptyStateVariant, EmptyStateBody, Title } from '@patternfly/react-core';
import { ExclamationCircleIcon } from '@patternfly/react-icons';
import './Unavailable.css';
var Unavailable = function () {
    return (React.createElement(EmptyState, { variant: EmptyStateVariant.large, className: "ins-c-empty-state__unavailable pf-m-redhat-font" },
        React.createElement(EmptyStateIcon, { icon: ExclamationCircleIcon }),
        React.createElement(Title, { headingLevel: "h5", size: "lg" }, "This page is temporarily unavailable"),
        React.createElement(EmptyStateBody, null,
            "Try refreshing the page. If the problem persists, contact your organization administrator or visit our",
            React.createElement("a", { href: "https://status.redhat.com/", target: "_blank", rel: "noopener noreferrer" },
                ' ',
                "status page"),
            ' ',
            "for known outages.")));
};
export default Unavailable;
//# sourceMappingURL=Unavailable.js.map