var __assign = (this && this.__assign) || function () {
    __assign = Object.assign || function(t) {
        for (var s, i = 1, n = arguments.length; i < n; i++) {
            s = arguments[i];
            for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p))
                t[p] = s[p];
        }
        return t;
    };
    return __assign.apply(this, arguments);
};
import React, { useState } from 'react';
import propTypes from 'prop-types';
import classNames from 'classnames';
import { Button, Stack, StackItem } from '@patternfly/react-core';
import sanitizeHtml from 'sanitize-html';
import './truncate.css';
var dangerousHtml = function (html) { return ({ __html: sanitizeHtml(html) }); };
var Truncate = function (_a) {
    var _b, _c;
    var _d = _a.text, text = _d === void 0 ? '' : _d, _e = _a.length, length = _e === void 0 ? 150 : _e, _f = _a.expandText, expandText = _f === void 0 ? 'Read more' : _f, _g = _a.hideExpandText, hideExpandText = _g === void 0 ? false : _g, _h = _a.expandOnMouseOver, expandOnMouseOver = _h === void 0 ? false : _h, _j = _a.collapseText, collapseText = _j === void 0 ? 'Collapse' : _j, className = _a.className, inline = _a.inline, spaceBetween = _a.spaceBetween;
    var truncateClasses = classNames('ins-c-truncate', className, (_b = {}, _b["is-inline"] = inline, _b), (_c = {}, _c["is-block"] = !inline, _c));
    var trimmedText = text.substring(0, length);
    var textOverflow = text.length > length;
    var _k = useState(false), showText = _k[0], setShowText = _k[1];
    var toggleText = function (event) {
        event && event.preventDefault();
        setShowText(!showText);
    };
    var expandButton = (React.createElement(Button, { className: "ins-c-expand-button", variant: "link", onClick: toggleText }, expandText));
    var collapseButton = (React.createElement(Button, { className: "ins-c-collapse-button", variant: "link", onClick: toggleText }, collapseText));
    var textWithOverflow = showText === false ? "".concat(trimmedText).concat(textOverflow ? '...' : '') : text;
    var html = dangerousHtml(textWithOverflow);
    var mouseOverHandler = expandOnMouseOver && {
        onMouseEnter: function () { return setShowText(true); },
        onMouseLeave: function () { return setShowText(false); },
    };
    return inline ? (React.createElement(React.Fragment, null,
        React.createElement("span", __assign({ className: truncateClasses, "widget-type": "InsightsTruncateInline", dangerouslySetInnerHTML: html }, mouseOverHandler)),
        !hideExpandText && textOverflow && (showText === false ? expandButton : collapseButton))) : (React.createElement(Stack, { className: truncateClasses },
        React.createElement(StackItem, __assign({}, mouseOverHandler),
            React.createElement("span", { "widget-type": "InsightsTruncateBlock", dangerouslySetInnerHTML: html })),
        !hideExpandText && textOverflow && (React.createElement(StackItem, { className: spaceBetween && 'pf-u-mt-sm' }, showText === false ? expandButton : collapseButton))));
};
Truncate.propTypes = {
    className: propTypes.string,
    text: propTypes.string,
    length: propTypes.number,
    expandText: propTypes.string,
    collapseText: propTypes.string,
    inline: propTypes.bool,
    spaceBetween: propTypes.bool,
    hideExpandText: propTypes.bool,
    expandOnMouseOver: propTypes.bool,
};
export default Truncate;
//# sourceMappingURL=Truncate.js.map