var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (Object.prototype.hasOwnProperty.call(b, p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        if (typeof b !== "function" && b !== null)
            throw new TypeError("Class extends value " + String(b) + " is not a constructor or null");
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
var __assign = (this && this.__assign) || function () {
    __assign = Object.assign || function(t) {
        for (var s, i = 1, n = arguments.length; i < n; i++) {
            s = arguments[i];
            for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p))
                t[p] = s[p];
        }
        return t;
    };
    return __assign.apply(this, arguments);
};
var __rest = (this && this.__rest) || function (s, e) {
    var t = {};
    for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p) && e.indexOf(p) < 0)
        t[p] = s[p];
    if (s != null && typeof Object.getOwnPropertySymbols === "function")
        for (var i = 0, p = Object.getOwnPropertySymbols(s); i < p.length; i++) {
            if (e.indexOf(p[i]) < 0 && Object.prototype.propertyIsEnumerable.call(s, p[i]))
                t[p[i]] = s[p[i]];
        }
    return t;
};
import React, { Component } from 'react';
import PropTypes from 'prop-types';
import { CaretDownIcon, CaretUpIcon, CheckIcon } from '@patternfly/react-icons';
import { Dropdown, DropdownItem, DropdownToggle } from '@patternfly/react-core';
var PaginationNav = (function (_super) {
    __extends(PaginationNav, _super);
    function PaginationNav() {
        var _this = _super !== null && _super.apply(this, arguments) || this;
        _this.state = {
            isOpen: false,
        };
        _this.onSelect = function () {
            _this.setState({
                isOpen: !_this.state.isOpen,
            });
        };
        _this.onToggle = function (isOpen) {
            _this.setState({
                isOpen: isOpen,
            });
        };
        return _this;
    }
    PaginationNav.prototype.render = function () {
        var _a = this.props, itemsTitle = _a.itemsTitle, itemsStart = _a.itemsStart, itemsEnd = _a.itemsEnd, widtgetId = _a.widtgetId, dropDirection = _a.dropDirection, onSetPerPage = _a.onSetPerPage, itemCount = _a.itemCount, perPageOptions = _a.perPageOptions, className = _a.className, perPage = _a.perPage, props = __rest(_a, ["itemsTitle", "itemsStart", "itemsEnd", "widtgetId", "dropDirection", "onSetPerPage", "itemCount", "perPageOptions", "className", "perPage"]);
        var isOpen = this.state.isOpen;
        return (React.createElement("div", __assign({ className: "pf-c-options-menu ".concat(className) }, props),
            React.createElement("span", { id: "".concat(widtgetId, "-label"), hidden: true }, "Items per page:"),
            React.createElement("div", { className: "pf-c-options-menu__toggle pf-m-text pf-m-plain" },
                React.createElement(Dropdown, { direction: dropDirection, isPlain: true, isOpen: isOpen, onSelect: this.onSelect, dropdownItems: perPageOptions.map(function (_a) {
                        var title = _a.title, value = _a.value;
                        return (React.createElement(DropdownItem, { onClick: function (event) { return value !== perPage && onSetPerPage(event, value); }, key: value, component: "button" },
                            title,
                            value === perPage && React.createElement(CheckIcon, { className: "pf-c-options-menu__menu-item-icon", size: "md" })));
                    }), toggle: React.createElement(DropdownToggle, { onToggle: this.onToggle, toggleIndicator: null, className: "pf-c-options-menu__toggle-button" },
                        React.createElement("span", { className: "pf-c-options-menu__toggle-text" },
                            React.createElement("b", null,
                                itemsStart,
                                " - ",
                                itemsEnd),
                            ' ',
                            "of ",
                            React.createElement("b", null, itemCount),
                            " ",
                            itemsTitle),
                        dropDirection === 'up' ? React.createElement(CaretUpIcon, null) : React.createElement(CaretDownIcon, null)) }))));
    };
    return PaginationNav;
}(Component));
PaginationNav.propTypes = {
    itemsTitle: PropTypes.string,
    itemsStart: PropTypes.number,
    itemsEnd: PropTypes.number,
    dropDirection: PropTypes.string,
    widtgetId: PropTypes.string,
    onSetPerPage: PropTypes.func,
    itemCount: PropTypes.number.isRequired,
    perPage: PropTypes.number,
    perPageOptions: PropTypes.arrayOf(PropTypes.shape({
        title: PropTypes.node,
        value: PropTypes.number,
    })),
    className: PropTypes.string,
};
PaginationNav.defaultProps = {
    itemsTitle: 'items',
    dropDirection: 'up',
    className: '',
};
export default PaginationNav;
//# sourceMappingURL=PaginationMenu.js.map