var __assign = (this && this.__assign) || function () {
    __assign = Object.assign || function(t) {
        for (var s, i = 1, n = arguments.length; i < n; i++) {
            s = arguments[i];
            for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p))
                t[p] = s[p];
        }
        return t;
    };
    return __assign.apply(this, arguments);
};
var __rest = (this && this.__rest) || function (s, e) {
    var t = {};
    for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p) && e.indexOf(p) < 0)
        t[p] = s[p];
    if (s != null && typeof Object.getOwnPropertySymbols === "function")
        for (var i = 0, p = Object.getOwnPropertySymbols(s); i < p.length; i++) {
            if (e.indexOf(p[i]) < 0 && Object.prototype.propertyIsEnumerable.call(s, p[i]))
                t[p[i]] = s[p[i]];
        }
    return t;
};
import React from 'react';
import classNames from 'classnames';
import { EmptyState, EmptyStateBody, Title, Stack, StackItem, EmptyStateIcon } from '@patternfly/react-core';
import { HourglassHalfIcon } from '@patternfly/react-icons';
import './maintenance.css';
var Maintenance = function (_a) {
    var _b = _a.utcStartTime, utcStartTime = _b === void 0 ? '10am' : _b, _c = _a.utcEndTime, utcEndTime = _c === void 0 ? '12am' : _c, _d = _a.startTime, startTime = _d === void 0 ? '6am' : _d, _e = _a.endTime, endTime = _e === void 0 ? '8am' : _e, _f = _a.timeZone, timeZone = _f === void 0 ? 'EST' : _f, description = _a.description, _g = _a.redirectLink, redirectLink = _g === void 0 ? 'https://status.redhat.com/incidents' : _g, className = _a.className, props = __rest(_a, ["utcStartTime", "utcEndTime", "startTime", "endTime", "timeZone", "description", "redirectLink", "className"]);
    var emptyStateClassName = classNames(className, 'ins-c-empty-state__maintenance');
    return (React.createElement(EmptyState, __assign({ className: emptyStateClassName }, props),
        React.createElement(EmptyStateIcon, { icon: HourglassHalfIcon }),
        React.createElement(Title, { headingLevel: "h4", size: "lg" }, "Maintenance in progress"),
        React.createElement(EmptyStateBody, null, description ? (description) : (React.createElement(Stack, null,
            React.createElement(StackItem, null, "We are currently undergoing scheduled maintenance and will be"),
            React.createElement(StackItem, null,
                "unavailable from ",
                utcStartTime,
                " to ",
                utcEndTime,
                " UTC (",
                startTime,
                "-",
                endTime,
                " ",
                timeZone,
                ")."),
            React.createElement(StackItem, null,
                "For more information please visit ",
                React.createElement("a", { href: redirectLink }, "status.redhat.com"),
                "."))))));
};
export default Maintenance;
//# sourceMappingURL=Maintenance.js.map