var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (Object.prototype.hasOwnProperty.call(b, p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        if (typeof b !== "function" && b !== null)
            throw new TypeError("Class extends value " + String(b) + " is not a constructor or null");
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
var __assign = (this && this.__assign) || function () {
    __assign = Object.assign || function(t) {
        for (var s, i = 1, n = arguments.length; i < n; i++) {
            s = arguments[i];
            for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p))
                t[p] = s[p];
        }
        return t;
    };
    return __assign.apply(this, arguments);
};
import React, { Component } from 'react';
import { Checkbox, Radio } from '@patternfly/react-core';
import PropTypes from 'prop-types';
var FilterInput = (function (_super) {
    __extends(FilterInput, _super);
    function FilterInput() {
        var _this = _super !== null && _super.apply(this, arguments) || this;
        _this.state = {
            checked: false,
        };
        _this.handleChange = function (checked) {
            var _a = _this.props, type = _a.type, addRemoveFilters = _a.addRemoveFilters, param = _a.param, value = _a.value;
            var updateState;
            switch (type) {
                case 'checkbox':
                    updateState = { checked: !_this.state.checked };
                    break;
            }
            _this.setState(__assign({}, updateState));
            addRemoveFilters(value, param, type, checked);
        };
        return _this;
    }
    FilterInput.prototype.componentDidMount = function () {
        var _a = this.props, type = _a.type, filters = _a.filters, param = _a.param, value = _a.value;
        switch (type) {
            case 'checkbox':
                param in filters && filters[param] && filters[param].includes(value) ? this.setState({ checked: true }) : this.setState({ checked: false });
                break;
        }
    };
    FilterInput.prototype.render = function () {
        var _this = this;
        var _a = this.props, label = _a.label, id = _a.id, param = _a.param, value = _a.value, type = _a.type, filters = _a.filters;
        var checked = this.state.checked;
        return (function () {
            switch (type) {
                case 'checkbox':
                    return (React.createElement(Checkbox, { "aria-label": label, id: id, isChecked: checked, label: label, onChange: _this.handleChange, param: param, value: value, ouiaId: label }));
                case 'radio':
                    return (React.createElement(Radio, { isChecked: filters[param] === value, "aria-label": label, id: id, label: label, name: param, onChange: _this.handleChange, param: param, value: value, ouiaId: label }));
            }
        })();
    };
    return FilterInput;
}(Component));
FilterInput.propTypes = {
    addRemoveFilters: PropTypes.func,
    className: PropTypes.string,
    currentPage: PropTypes.string,
    id: PropTypes.string.isRequired,
    label: PropTypes.node.isRequired,
    param: PropTypes.string,
    value: PropTypes.any,
    filters: PropTypes.object,
    type: PropTypes.string,
};
FilterInput.defaultProps = {
    addRemoveFilters: Function.prototype,
    className: null,
    currentPage: null,
    param: null,
    filters: {},
    type: 'checkbox',
    value: undefined,
};
export default FilterInput;
//# sourceMappingURL=FilterInput.js.map