"use strict";
var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (Object.prototype.hasOwnProperty.call(b, p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        if (typeof b !== "function" && b !== null)
            throw new TypeError("Class extends value " + String(b) + " is not a constructor or null");
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
var __assign = (this && this.__assign) || function () {
    __assign = Object.assign || function(t) {
        for (var s, i = 1, n = arguments.length; i < n; i++) {
            s = arguments[i];
            for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p))
                t[p] = s[p];
        }
        return t;
    };
    return __assign.apply(this, arguments);
};
var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    Object.defineProperty(o, k2, { enumerable: true, get: function() { return m[k]; } });
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __setModuleDefault = (this && this.__setModuleDefault) || (Object.create ? (function(o, v) {
    Object.defineProperty(o, "default", { enumerable: true, value: v });
}) : function(o, v) {
    o["default"] = v;
});
var __importStar = (this && this.__importStar) || function (mod) {
    if (mod && mod.__esModule) return mod;
    var result = {};
    if (mod != null) for (var k in mod) if (k !== "default" && Object.prototype.hasOwnProperty.call(mod, k)) __createBinding(result, mod, k);
    __setModuleDefault(result, mod);
    return result;
};
var __rest = (this && this.__rest) || function (s, e) {
    var t = {};
    for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p) && e.indexOf(p) < 0)
        t[p] = s[p];
    if (s != null && typeof Object.getOwnPropertySymbols === "function")
        for (var i = 0, p = Object.getOwnPropertySymbols(s); i < p.length; i++) {
            if (e.indexOf(p[i]) < 0 && Object.prototype.propertyIsEnumerable.call(s, p[i]))
                t[p[i]] = s[p[i]];
        }
    return t;
};
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
var react_1 = __importStar(require("react"));
var prop_types_1 = __importDefault(require("prop-types"));
var classnames_1 = __importDefault(require("classnames"));
var react_core_1 = require("@patternfly/react-core");
require("./wizard.css");
var Wizard = (function (_super) {
    __extends(Wizard, _super);
    function Wizard() {
        var _this = _super !== null && _super.apply(this, arguments) || this;
        _this.state = {
            currentStep: 0,
        };
        _this.handleNextModalStep = function () {
            _this.setState(function (_a) {
                var currentStep = _a.currentStep;
                return ({
                    currentStep: currentStep + 1,
                });
            });
        };
        _this.handlePreviousModalStep = function () {
            _this.setState(function (_a) {
                var currentStep = _a.currentStep;
                return ({
                    currentStep: currentStep - 1,
                });
            });
        };
        _this.handleOnClose = function (submit) {
            var result = _this.props.onClose(submit);
            if (result === false) {
                return;
            }
            _this.setState({ currentStep: 0 });
        };
        _this.handleKeyPress = function (event) {
            if (event.key === 'Enter' && _this.props.isValidated === true) {
                _this.handleNextModalStep();
            }
        };
        return _this;
    }
    Wizard.prototype.render = function () {
        var _this = this;
        var _a = this.props, isLarge = _a.isLarge, title = _a.title, className = _a.className, isOpen = _a.isOpen, isValidated = _a.isValidated, confirmAction = _a.confirmAction, props = __rest(_a, ["isLarge", "title", "className", "isOpen", "isValidated", "confirmAction"]);
        var wizardClasses = (0, classnames_1.default)('ins-c-wizard', className);
        var renderModalActions = [
            this.state.currentStep < this.props.content.length - 1 ? (react_1.default.createElement(react_core_1.Button, { key: "Next", action: "next", variant: "primary", isDisabled: !isValidated, onClick: this.handleNextModalStep }, "Next")) : (react_1.default.createElement(react_core_1.Button, { key: "confirm", action: "confirm", variant: "primary", isDisabled: !isValidated, onClick: function () { return _this.handleOnClose(true); } }, confirmAction)),
            this.state.currentStep !== 0 && (react_1.default.createElement(react_core_1.Button, { key: "back", action: "back", variant: "secondary", onClick: this.handlePreviousModalStep },
                ' ',
                "Back",
                ' ')),
            react_1.default.createElement(react_core_1.Button, { key: "cancel", action: "cancel", variant: "secondary", onClick: function () { return _this.handleOnClose(false); } }, "Cancel"),
        ];
        return (react_1.default.createElement(react_core_1.Modal, __assign({}, props, { onKeyPress: this.handleKeyPress, variant: "large", title: title, className: wizardClasses, isOpen: isOpen, onClose: function () { return _this.handleOnClose(false); }, actions: renderModalActions }), this.props.content[this.state.currentStep]));
    };
    return Wizard;
}(react_1.Component));
Wizard.propTypes = {
    isValidated: prop_types_1.default.bool,
    isLarge: prop_types_1.default.bool,
    title: prop_types_1.default.string,
    className: prop_types_1.default.string,
    confirmAction: prop_types_1.default.string,
    isOpen: prop_types_1.default.any,
    content: prop_types_1.default.array,
    onClose: prop_types_1.default.func,
};
Wizard.defaultProps = {
    onClose: function (f) { return f; },
    isValidated: true,
    confirmAction: 'Confirm',
};
exports.default = Wizard;
//# sourceMappingURL=Wizard.js.map