"use strict";
var __assign = (this && this.__assign) || function () {
    __assign = Object.assign || function(t) {
        for (var s, i = 1, n = arguments.length; i < n; i++) {
            s = arguments[i];
            for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p))
                t[p] = s[p];
        }
        return t;
    };
    return __assign.apply(this, arguments);
};
var __rest = (this && this.__rest) || function (s, e) {
    var t = {};
    for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p) && e.indexOf(p) < 0)
        t[p] = s[p];
    if (s != null && typeof Object.getOwnPropertySymbols === "function")
        for (var i = 0, p = Object.getOwnPropertySymbols(s); i < p.length; i++) {
            if (e.indexOf(p[i]) < 0 && Object.prototype.propertyIsEnumerable.call(s, p[i]))
                t[p[i]] = s[p[i]];
        }
    return t;
};
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
var react_1 = __importDefault(require("react"));
var react_core_1 = require("@patternfly/react-core");
var react_icons_1 = require("@patternfly/react-icons");
require("./styles.css");
var treeTableDecorator = function (onCollapse) {
    return function (value, _a) {
        if (value === void 0) { value = ''; }
        if (_a === void 0) { _a = { rowData: {} }; }
        var rowData = _a.rowData, props = __rest(_a, ["rowData"]);
        return ({
            value: value,
            children: rowData.level !== undefined ? (react_1.default.createElement("div", { className: "pf-c-treeview__control" },
                rowData.isTreeOpen !== undefined && (react_1.default.createElement("div", { className: "pf-c-treeview__toggle" },
                    react_1.default.createElement(react_core_1.Button, { variant: "plain", onClick: function (event) { return onCollapse && onCollapse(event, value, __assign({ rowData: rowData }, props)); } },
                        react_1.default.createElement(react_icons_1.AngleRightIcon, { className: "pf-c-treeview__toggle-icon", "aria-hidden": "true" })))),
                react_1.default.createElement("div", { className: "pf-c-treeview__control-text" }, typeof value === 'object' ? value.title : value))) : typeof value === 'object' ? (value.title) : (value),
            className: rowData.level !== undefined ? 'pf-c-treeview__title-cell' : '',
        });
    };
};
exports.default = treeTableDecorator;
//# sourceMappingURL=decorator.js.map