"use strict";
var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (Object.prototype.hasOwnProperty.call(b, p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        if (typeof b !== "function" && b !== null)
            throw new TypeError("Class extends value " + String(b) + " is not a constructor or null");
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
var __spreadArray = (this && this.__spreadArray) || function (to, from, pack) {
    if (pack || arguments.length === 2) for (var i = 0, l = from.length, ar; i < l; i++) {
        if (ar || !(i in from)) {
            if (!ar) ar = Array.prototype.slice.call(from, 0, i);
            ar[i] = from[i];
        }
    }
    return to.concat(ar || Array.prototype.slice.call(from));
};
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
var react_1 = __importDefault(require("react"));
var react_table_1 = require("@patternfly/react-table");
var Skeleton_1 = require("../Skeleton");
var classnames_1 = __importDefault(require("classnames"));
var prop_types_1 = __importDefault(require("prop-types"));
require("./SkeletonTable.css");
var SkeletonTable = (function (_super) {
    __extends(SkeletonTable, _super);
    function SkeletonTable() {
        var _this = _super !== null && _super.apply(this, arguments) || this;
        _this.createColumns = function () {
            var _a = _this.props, colSize = _a.colSize, isDark = _a.isDark;
            return __spreadArray([], Array(colSize), true).map(function () { return ({ title: react_1.default.createElement(Skeleton_1.Skeleton, { isDark: isDark, size: Skeleton_1.SkeletonSize.sm }) }); });
        };
        _this.getColumns = function () {
            var _a = _this.props, paddingColumnSize = _a.paddingColumnSize, columns = _a.columns;
            return _this.newArray(paddingColumnSize)
                .map(function () { return ''; })
                .concat(columns || _this.createColumns());
        };
        _this.createRows = function () {
            var _a = _this.props, colSize = _a.colSize, rowSize = _a.rowSize, columns = _a.columns, paddingColumnSize = _a.paddingColumnSize, isDark = _a.isDark;
            var numberOfCols = columns ? columns.length : colSize;
            return _this.newArray(rowSize).map(function () { return ({
                disableSelection: true,
                cells: _this.newArray(paddingColumnSize)
                    .map(function () { return ''; })
                    .concat(_this.newArray(numberOfCols).map(function () { return ({ title: react_1.default.createElement(Skeleton_1.Skeleton, { isDark: isDark, size: Skeleton_1.SkeletonSize.md }) }); })),
            }); });
        };
        _this.selectVariant = function () {
            var hasRadio = _this.props.hasRadio;
            return hasRadio ? (react_table_1.RowSelectVariant === null || react_table_1.RowSelectVariant === void 0 ? void 0 : react_table_1.RowSelectVariant.radio) || 'radio' : (react_table_1.RowSelectVariant === null || react_table_1.RowSelectVariant === void 0 ? void 0 : react_table_1.RowSelectVariant.checkbox) || 'checkbox';
        };
        _this.newArray = function (size) { return __spreadArray([], Array(size), true); };
        return _this;
    }
    SkeletonTable.prototype.render = function () {
        var _a = this.props, canSelectAll = _a.canSelectAll, isSelectable = _a.isSelectable, sortBy = _a.sortBy, variant = _a.variant, isDark = _a.isDark;
        return (react_1.default.createElement(react_table_1.Table, { className: (0, classnames_1.default)({
                'ins-c-skeleton-table__dark': isDark,
            }), cells: this.getColumns(), rows: this.createRows(), sortBy: sortBy, "aria-label": "Loading", onSelect: isSelectable, selectVariant: isSelectable ? this.selectVariant() : null, canSelectAll: canSelectAll, variant: variant },
            react_1.default.createElement(react_table_1.TableHeader, null),
            react_1.default.createElement(react_table_1.TableBody, null)));
    };
    return SkeletonTable;
}(react_1.default.Component));
SkeletonTable.propTypes = {
    colSize: prop_types_1.default.number,
    rowSize: prop_types_1.default.number,
    columns: prop_types_1.default.array,
    paddingColumnSize: prop_types_1.default.number,
    sortBy: prop_types_1.default.shape({
        index: prop_types_1.default.number,
        direction: prop_types_1.default.oneOf(['asc', 'desc']),
    }),
    isSelectable: prop_types_1.default.bool,
    canSelectAll: prop_types_1.default.bool,
    hasRadio: prop_types_1.default.bool,
    variant: prop_types_1.default.string,
    isDark: prop_types_1.default.bool,
};
SkeletonTable.defaultProps = {
    rowSize: 0,
    paddingColumnSize: 0,
    canSelectAll: false,
    isSelectable: false,
    hasRadio: false,
    variant: null,
    isDark: false,
};
exports.default = SkeletonTable;
//# sourceMappingURL=SkeletonTable.js.map