"use strict";
var __assign = (this && this.__assign) || function () {
    __assign = Object.assign || function(t) {
        for (var s, i = 1, n = arguments.length; i < n; i++) {
            s = arguments[i];
            for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p))
                t[p] = s[p];
        }
        return t;
    };
    return __assign.apply(this, arguments);
};
var __rest = (this && this.__rest) || function (s, e) {
    var t = {};
    for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p) && e.indexOf(p) < 0)
        t[p] = s[p];
    if (s != null && typeof Object.getOwnPropertySymbols === "function")
        for (var i = 0, p = Object.getOwnPropertySymbols(s); i < p.length; i++) {
            if (e.indexOf(p[i]) < 0 && Object.prototype.propertyIsEnumerable.call(s, p[i]))
                t[p[i]] = s[p[i]];
        }
    return t;
};
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
var react_1 = __importDefault(require("react"));
var react_core_1 = require("@patternfly/react-core");
var react_icons_1 = require("@patternfly/react-icons");
require("./NotAuthorized.css");
var ContactBody = function () { return (react_1.default.createElement(react_1.default.Fragment, null,
    "Contact your organization administrator(s) for more information or visit\u00A0",
    react_1.default.createElement("a", { href: "./settings/my-user-access" }, "My User Access"),
    "\u00A0 to learn more about your permissions.")); };
var NotAuthorized = function (_a) {
    var _b = _a.prevPageButtonText, prevPageButtonText = _b === void 0 ? 'Return to previous page' : _b, _c = _a.toLandingPageText, toLandingPageText = _c === void 0 ? 'Go to landing page' : _c, title = _a.title, _d = _a.actions, actions = _d === void 0 ? null : _d, serviceName = _a.serviceName, _e = _a.icon, Icon = _e === void 0 ? react_icons_1.LockIcon : _e, _f = _a.description, description = _f === void 0 ? react_1.default.createElement(ContactBody, null) : _f, _g = _a.showReturnButton, showReturnButton = _g === void 0 ? true : _g, className = _a.className, props = __rest(_a, ["prevPageButtonText", "toLandingPageText", "title", "actions", "serviceName", "icon", "description", "showReturnButton", "className"]);
    var heading = title || "You do not have access to ".concat(serviceName);
    return (react_1.default.createElement(react_core_1.EmptyState, __assign({ variant: react_core_1.EmptyStateVariant.full, className: "ins-c-not-authorized ".concat(className || '') }, props),
        react_1.default.createElement(react_core_1.EmptyStateIcon, { icon: Icon }),
        react_1.default.createElement(react_core_1.Title, { headingLevel: "h5", size: "lg" }, heading),
        react_1.default.createElement(react_core_1.EmptyStateBody, null, description),
        actions,
        showReturnButton &&
            (document.referrer ? (react_1.default.createElement(react_core_1.Button, { variant: "primary", onClick: function () { return history.back(); } }, prevPageButtonText)) : (react_1.default.createElement(react_core_1.Button, { variant: "primary", component: "a", href: "." }, toLandingPageText)))));
};
exports.default = NotAuthorized;
//# sourceMappingURL=NotAuthorized.js.map