"use strict";
var __assign = (this && this.__assign) || function () {
    __assign = Object.assign || function(t) {
        for (var s, i = 1, n = arguments.length; i < n; i++) {
            s = arguments[i];
            for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p))
                t[p] = s[p];
        }
        return t;
    };
    return __assign.apply(this, arguments);
};
var __rest = (this && this.__rest) || function (s, e) {
    var t = {};
    for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p) && e.indexOf(p) < 0)
        t[p] = s[p];
    if (s != null && typeof Object.getOwnPropertySymbols === "function")
        for (var i = 0, p = Object.getOwnPropertySymbols(s); i < p.length; i++) {
            if (e.indexOf(p[i]) < 0 && Object.prototype.propertyIsEnumerable.call(s, p[i]))
                t[p[i]] = s[p[i]];
        }
    return t;
};
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
var react_1 = __importDefault(require("react"));
var classnames_1 = __importDefault(require("classnames"));
var react_core_1 = require("@patternfly/react-core");
var react_icons_1 = require("@patternfly/react-icons");
require("./maintenance.css");
var Maintenance = function (_a) {
    var _b = _a.utcStartTime, utcStartTime = _b === void 0 ? '10am' : _b, _c = _a.utcEndTime, utcEndTime = _c === void 0 ? '12am' : _c, _d = _a.startTime, startTime = _d === void 0 ? '6am' : _d, _e = _a.endTime, endTime = _e === void 0 ? '8am' : _e, _f = _a.timeZone, timeZone = _f === void 0 ? 'EST' : _f, description = _a.description, _g = _a.redirectLink, redirectLink = _g === void 0 ? 'https://status.redhat.com/incidents' : _g, className = _a.className, props = __rest(_a, ["utcStartTime", "utcEndTime", "startTime", "endTime", "timeZone", "description", "redirectLink", "className"]);
    var emptyStateClassName = (0, classnames_1.default)(className, 'ins-c-empty-state__maintenance');
    return (react_1.default.createElement(react_core_1.EmptyState, __assign({ className: emptyStateClassName }, props),
        react_1.default.createElement(react_core_1.EmptyStateIcon, { icon: react_icons_1.HourglassHalfIcon }),
        react_1.default.createElement(react_core_1.Title, { headingLevel: "h4", size: "lg" }, "Maintenance in progress"),
        react_1.default.createElement(react_core_1.EmptyStateBody, null, description ? (description) : (react_1.default.createElement(react_core_1.Stack, null,
            react_1.default.createElement(react_core_1.StackItem, null, "We are currently undergoing scheduled maintenance and will be"),
            react_1.default.createElement(react_core_1.StackItem, null,
                "unavailable from ",
                utcStartTime,
                " to ",
                utcEndTime,
                " UTC (",
                startTime,
                "-",
                endTime,
                " ",
                timeZone,
                ")."),
            react_1.default.createElement(react_core_1.StackItem, null,
                "For more information please visit ",
                react_1.default.createElement("a", { href: redirectLink }, "status.redhat.com"),
                "."))))));
};
exports.default = Maintenance;
//# sourceMappingURL=Maintenance.js.map