"use strict";
var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (Object.prototype.hasOwnProperty.call(b, p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        if (typeof b !== "function" && b !== null)
            throw new TypeError("Class extends value " + String(b) + " is not a constructor or null");
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
var __assign = (this && this.__assign) || function () {
    __assign = Object.assign || function(t) {
        for (var s, i = 1, n = arguments.length; i < n; i++) {
            s = arguments[i];
            for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p))
                t[p] = s[p];
        }
        return t;
    };
    return __assign.apply(this, arguments);
};
var __rest = (this && this.__rest) || function (s, e) {
    var t = {};
    for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p) && e.indexOf(p) < 0)
        t[p] = s[p];
    if (s != null && typeof Object.getOwnPropertySymbols === "function")
        for (var i = 0, p = Object.getOwnPropertySymbols(s); i < p.length; i++) {
            if (e.indexOf(p[i]) < 0 && Object.prototype.propertyIsEnumerable.call(s, p[i]))
                t[p[i]] = s[p[i]];
        }
    return t;
};
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
var react_core_1 = require("@patternfly/react-core");
var prop_types_1 = __importDefault(require("prop-types"));
var react_1 = __importDefault(require("react"));
var LongTextTooltip = (function (_super) {
    __extends(LongTextTooltip, _super);
    function LongTextTooltip(props) {
        return _super.call(this, props) || this;
    }
    LongTextTooltip.prototype.truncate = function (str, max) {
        return str.length > max ? str.substr(0, max - 1) + '…' : str;
    };
    LongTextTooltip.prototype.render = function () {
        var _a = this.props, content = _a.content, maxLength = _a.maxLength, tooltipMaxWidth = _a.tooltipMaxWidth, tooltipPosition = _a.tooltipPosition, rest = __rest(_a, ["content", "maxLength", "tooltipMaxWidth", "tooltipPosition"]);
        return (react_1.default.createElement(react_1.default.Fragment, null, content.length > maxLength ? (react_1.default.createElement(react_core_1.Tooltip, __assign({ maxWidth: tooltipMaxWidth, position: tooltipPosition, content: react_1.default.createElement("div", null, content) }, rest),
            react_1.default.createElement("div", null, this.truncate(content, maxLength)))) : (react_1.default.createElement("span", null, content))));
    };
    return LongTextTooltip;
}(react_1.default.Component));
LongTextTooltip.defaultProps = {
    content: '',
    maxLength: Infinity,
    tooltipPosition: 'top',
    tooltipMaxWidth: '50vw',
};
LongTextTooltip.propTypes = {
    content: prop_types_1.default.string,
    maxLength: prop_types_1.default.number,
    tooltipPosition: prop_types_1.default.string,
    tooltipMaxWidth: prop_types_1.default.string,
};
exports.default = LongTextTooltip;
//# sourceMappingURL=LongTextTooltip.js.map