"use strict";
var __assign = (this && this.__assign) || function () {
    __assign = Object.assign || function(t) {
        for (var s, i = 1, n = arguments.length; i < n; i++) {
            s = arguments[i];
            for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p))
                t[p] = s[p];
        }
        return t;
    };
    return __assign.apply(this, arguments);
};
var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    Object.defineProperty(o, k2, { enumerable: true, get: function() { return m[k]; } });
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __setModuleDefault = (this && this.__setModuleDefault) || (Object.create ? (function(o, v) {
    Object.defineProperty(o, "default", { enumerable: true, value: v });
}) : function(o, v) {
    o["default"] = v;
});
var __importStar = (this && this.__importStar) || function (mod) {
    if (mod && mod.__esModule) return mod;
    var result = {};
    if (mod != null) for (var k in mod) if (k !== "default" && Object.prototype.hasOwnProperty.call(mod, k)) __createBinding(result, mod, k);
    __setModuleDefault(result, mod);
    return result;
};
var __spreadArray = (this && this.__spreadArray) || function (to, from, pack) {
    if (pack || arguments.length === 2) for (var i = 0, l = from.length, ar; i < l; i++) {
        if (ar || !(i in from)) {
            if (!ar) ar = Array.prototype.slice.call(from, 0, i);
            ar[i] = from[i];
        }
    }
    return to.concat(ar || Array.prototype.slice.call(from));
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.useTagsFilter = exports.tagsFilterReducer = exports.TAGS_FILTER = exports.tagsFilterState = void 0;
var react_1 = __importStar(require("react"));
var constants_1 = require("./constants");
var react_core_1 = require("@patternfly/react-core");
require("./tagFilterHook.css");
exports.tagsFilterState = { tagsFilter: {} };
exports.TAGS_FILTER = 'TAGS_FILTER';
var tagsFilterReducer = function (_state, _a) {
    var type = _a.type, payload = _a.payload;
    return (__assign({}, (type === exports.TAGS_FILTER && {
        tagsFilter: payload,
    })));
};
exports.tagsFilterReducer = tagsFilterReducer;
var useTagsFilter = function (allTags, loaded, additionalTagsCount, onShowMoreClick, _a, itemText, showMoreTitle) {
    if (allTags === void 0) { allTags = []; }
    if (loaded === void 0) { loaded = false; }
    if (additionalTagsCount === void 0) { additionalTagsCount = 0; }
    var _b = _a === void 0 ? [exports.tagsFilterState] : _a, globalState = _b[0], dispatch = _b[1];
    if (itemText === void 0) { itemText = 'item'; }
    var _c = (0, react_1.useState)({
        allTags: [],
        loaded: false,
        additionalTagsCount: 0,
    }), state = _c[0], setState = _c[1];
    (0, react_1.useEffect)(function () {
        setState(function () { return ({
            allTags: allTags,
            loaded: loaded,
            additionalTagsCount: additionalTagsCount,
        }); });
    }, [loaded]);
    var _d = (0, react_1.useState)({}), selectedStateTags = _d[0], setStateValue = _d[1];
    var selectedTags = dispatch ? globalState.tagsFilter : selectedStateTags;
    var setValue = dispatch ? function (newValue) { return dispatch({ type: exports.TAGS_FILTER, payload: newValue }); } : setStateValue;
    var _f = (0, react_1.useState)(''), filterTagsBy = _f[0], seFilterTagsBy = _f[1];
    var filter = __assign(__assign({ className: 'ins-c-tagfilter', onFilter: function (value) { return seFilterTagsBy(value); }, filterBy: filterTagsBy, onChange: function (_e, newSelection, group, item, groupKey, itemKey) {
            if (item.meta) {
                var isSelected = !!newSelection[groupKey][itemKey];
                newSelection[groupKey][itemKey] = {
                    isSelected: isSelected,
                    group: group,
                    item: item,
                };
                setValue(newSelection);
            }
        }, selected: selectedTags }, (additionalTagsCount && {
        onShowMore: function () {
            var props = [];
            for (var _i = 0; _i < arguments.length; _i++) {
                props[_i] = arguments[_i];
            }
            return onShowMoreClick && onShowMoreClick.apply(void 0, props);
        },
        showMoreTitle: showMoreTitle || "".concat(state.additionalTagsCount, " more tags available"),
    })), (loaded && allTags.length > 0
        ? {
            groups: __spreadArray([], (0, constants_1.constructGroups)(allTags, itemText), true),
        }
        : {
            value: '',
            items: [
                {
                    value: '',
                    label: !state.loaded ? (react_1.default.createElement("span", { key: "no-tags-tooltip" },
                        ' ',
                        react_1.default.createElement(react_core_1.Spinner, { size: "md" }),
                        ' ')) : (react_1.default.createElement("div", { className: "ins-c-tagfilter__no-tags" }, " No tags available ")),
                    isDisabled: true,
                    className: 'ins-c-tagfilter__tail',
                },
            ],
        }));
    return {
        filter: filter,
        chips: (0, constants_1.mapGroups)(selectedTags, 'chips'),
        selectedTags: selectedTags,
        setValue: setValue,
        filterTagsBy: filterTagsBy,
        seFilterTagsBy: seFilterTagsBy,
    };
};
exports.useTagsFilter = useTagsFilter;
//# sourceMappingURL=tagFilterHook.js.map