"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.calculateTooltip = exports.days = exports.hours = exports.minutes = exports.seconds = void 0;
exports.seconds = 1000;
exports.minutes = exports.seconds * 60;
exports.hours = exports.minutes * 60;
exports.days = exports.hours * 24;
var calculateTooltip = function (culled, warning, currDate) {
    var culledDate = new Date(culled);
    var warningDate = new Date(warning);
    var diffTime = new Date(currDate).valueOf() - warningDate.valueOf();
    var removeIn = Math.ceil((culledDate.valueOf() - new Date(currDate).valueOf()) / exports.days);
    var msg = "System scheduled for inventory removal in ".concat(removeIn, " days");
    if (diffTime >= 0) {
        return {
            isError: true,
            msg: msg,
        };
    }
    return {
        isWarn: true,
        msg: msg,
    };
};
exports.calculateTooltip = calculateTooltip;
//# sourceMappingURL=utils.js.map