"use strict";
var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (Object.prototype.hasOwnProperty.call(b, p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        if (typeof b !== "function" && b !== null)
            throw new TypeError("Class extends value " + String(b) + " is not a constructor or null");
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
var __assign = (this && this.__assign) || function () {
    __assign = Object.assign || function(t) {
        for (var s, i = 1, n = arguments.length; i < n; i++) {
            s = arguments[i];
            for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p))
                t[p] = s[p];
        }
        return t;
    };
    return __assign.apply(this, arguments);
};
var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    Object.defineProperty(o, k2, { enumerable: true, get: function() { return m[k]; } });
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __setModuleDefault = (this && this.__setModuleDefault) || (Object.create ? (function(o, v) {
    Object.defineProperty(o, "default", { enumerable: true, value: v });
}) : function(o, v) {
    o["default"] = v;
});
var __importStar = (this && this.__importStar) || function (mod) {
    if (mod && mod.__esModule) return mod;
    var result = {};
    if (mod != null) for (var k in mod) if (k !== "default" && Object.prototype.hasOwnProperty.call(mod, k)) __createBinding(result, mod, k);
    __setModuleDefault(result, mod);
    return result;
};
var __rest = (this && this.__rest) || function (s, e) {
    var t = {};
    for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p) && e.indexOf(p) < 0)
        t[p] = s[p];
    if (s != null && typeof Object.getOwnPropertySymbols === "function")
        for (var i = 0, p = Object.getOwnPropertySymbols(s); i < p.length; i++) {
            if (e.indexOf(p[i]) < 0 && Object.prototype.propertyIsEnumerable.call(s, p[i]))
                t[p[i]] = s[p[i]];
        }
    return t;
};
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
var react_1 = __importStar(require("react"));
var prop_types_1 = __importDefault(require("prop-types"));
var react_core_1 = require("@patternfly/react-core");
var TextFilter_1 = __importDefault(require("./TextFilter"));
var Radio = (function (_super) {
    __extends(Radio, _super);
    function Radio() {
        var _this = _super !== null && _super.apply(this, arguments) || this;
        _this.state = {
            isExpanded: false,
            checked: undefined,
        };
        _this.onToggle = function (isExpanded) {
            _this.setState({
                isExpanded: isExpanded,
            });
        };
        _this.calculateSelected = function () {
            var checked = _this.state.checked;
            var selectedValue = _this.props.value;
            return (selectedValue && (selectedValue.value || selectedValue)) || (checked && (checked.value || checked));
        };
        _this.onSelect = function (event, selection) {
            var onChange = _this.props.onChange;
            onChange(event, selection);
            _this.setState({ checked: selection });
        };
        return _this;
    }
    Radio.prototype.render = function () {
        var isExpanded = this.state.isExpanded;
        var _a = this.props, items = _a.items, placeholder = _a.placeholder, isDisabled = _a.isDisabled, className = _a.className;
        var checkedValue = this.calculateSelected();
        return (react_1.default.createElement(react_1.Fragment, null, !items || (items && items.length <= 0) ? (react_1.default.createElement(TextFilter_1.default, __assign({}, this.props, { value: "".concat(this.calculateSelected()) }))) : (react_1.default.createElement(react_core_1.Select, { className: className, variant: react_core_1.SelectVariant.single, "aria-label": "Select Input", isDisabled: isDisabled, onToggle: this.onToggle, onSelect: this.onSelect, isOpen: isExpanded, placeholderText: placeholder, ouiaId: placeholder }, items.map(function (_a, key) {
            var value = _a.value, isChecked = _a.isChecked, onChange = _a.onChange, label = _a.label, id = _a.id, item = __rest(_a, ["value", "isChecked", "onChange", "label", "id"]);
            return (react_1.default.createElement(react_core_1.SelectOption, __assign({}, item, { key: id || key, value: value || '' + key }),
                react_1.default.createElement(react_core_1.Radio, __assign({}, item, { name: id || "".concat(key, "-radio"), label: label, value: value || key, isChecked: isChecked ||
                        (checkedValue !== undefined && checkedValue === value) ||
                        (checkedValue !== undefined && checkedValue === '' + key) ||
                        false, onChange: function (_value, e) { return onChange && onChange(e, __assign({ id: id, label: label, value: value, isChecked: isChecked }, item), key); }, id: id || "".concat(value, "-").concat(key) }))));
        })))));
    };
    return Radio;
}(react_1.Component));
Radio.propTypes = {
    onChange: prop_types_1.default.func,
    value: prop_types_1.default.oneOfType([
        prop_types_1.default.string,
        prop_types_1.default.shape({
            label: prop_types_1.default.node,
            value: prop_types_1.default.string,
        }),
    ]),
    placeholder: prop_types_1.default.string,
    items: prop_types_1.default.arrayOf(prop_types_1.default.shape({
        value: prop_types_1.default.string,
        label: prop_types_1.default.node,
        id: prop_types_1.default.string,
        isChecked: prop_types_1.default.bool,
        onChange: prop_types_1.default.func,
    })),
    isDisabled: prop_types_1.default.bool,
    className: prop_types_1.default.string,
};
Radio.defaultProps = {
    items: [],
    onChange: function () { return undefined; },
    isDisabled: false,
};
exports.default = Radio;
//# sourceMappingURL=RadioFilter.js.map