import * as monaco from "monaco-editor/esm/vs/editor/editor.api";
import * as PropTypes from "prop-types";
import * as React from "react";
import { MonacoDiffEditorProps } from "./types";
import { noop } from "./utils";
declare class MonacoDiffEditor extends React.Component<MonacoDiffEditorProps> {
    static propTypes: {
        width: PropTypes.Requireable<string | number>;
        height: PropTypes.Requireable<string | number>;
        original: PropTypes.Requireable<string>;
        value: PropTypes.Requireable<string>;
        defaultValue: PropTypes.Requireable<string>;
        language: PropTypes.Requireable<string>;
        theme: PropTypes.Requireable<string>;
        options: PropTypes.Requireable<object>;
        overrideServices: PropTypes.Requireable<object>;
        editorDidMount: PropTypes.Requireable<(...args: any[]) => any>;
        editorWillMount: PropTypes.Requireable<(...args: any[]) => any>;
        onChange: PropTypes.Requireable<(...args: any[]) => any>;
        className: PropTypes.Requireable<string>;
    };
    static defaultProps: {
        width: string;
        height: string;
        original: any;
        value: any;
        defaultValue: string;
        language: string;
        theme: any;
        options: {};
        overrideServices: {};
        editorDidMount: typeof noop;
        editorWillMount: typeof noop;
        onChange: typeof noop;
        className: any;
    };
    editor?: monaco.editor.IStandaloneDiffEditor;
    private containerElement?;
    private _subscription;
    private __prevent_trigger_change_event?;
    constructor(props: MonacoDiffEditorProps);
    componentDidMount(): void;
    componentDidUpdate(prevProps: MonacoDiffEditorProps): void;
    componentWillUnmount(): void;
    assignRef: (component: HTMLDivElement) => void;
    editorWillMount(): monaco.editor.IStandaloneEditorConstructionOptions;
    editorDidMount(editor: monaco.editor.IStandaloneDiffEditor): void;
    initModels(value: string, original: string): void;
    initMonaco(): void;
    destroyMonaco(): void;
    render(): JSX.Element;
}
export default MonacoDiffEditor;
