import * as React from 'react';
import { Cluster, Disk, DiskRole, Host } from '../../../common';
export declare const useHostsTable: (cluster: Cluster) => {
    onDiskRole: (hostId: Host['id'], diskId: Disk['id'], role: DiskRole) => Promise<void>;
    onEditHost: (host: Host) => void;
    actionChecks: {
        canEditRole: (host: Host) => boolean;
        canInstallHost: (host: Host) => boolean;
        canEditDisks: (host: Host) => boolean;
        canEnable: (host: Host) => boolean;
        canDisable: (host: Host) => boolean;
        canDelete: (host: Host) => boolean;
        canEditHost: (host: Host) => boolean;
        canReset: (host: Host) => boolean;
    };
    onEditRole: ({ id, clusterId }: Host, role?: string | undefined) => Promise<void>;
    actionResolver: import("../../../common/components/hosts/AITable").ActionsResolver<Host>;
    onReset: () => void;
    onDelete: () => void;
    onAdditionalNtpSource: (additionalNtpSource: string, onError: (message: string) => void) => Promise<void>;
};
declare type HostsTableModalsProps = {
    cluster: Cluster;
    onReset: VoidFunction;
    onDelete: VoidFunction;
    onAdditionalNtpSource: (additionalNtpSource: string, onError: (message: string) => void) => Promise<void>;
};
export declare const HostsTableModals: React.FC<HostsTableModalsProps>;
export declare const getHostId: (host: Host) => string;
export {};
