import React from 'react';
import { Host, Inventory, Cluster } from '../../../common';
declare type HostIdAndHostname = {
    hostId: Host['id'];
    hostname: string;
};
declare type EditHostProps = {
    host: Host;
    inventory: Inventory;
};
declare type ResetClusterProps = {
    cluster: Cluster;
};
declare type CancelInstallationProps = {
    clusterId: Cluster['id'];
};
declare type DiscoveryImageDialogProps = {
    cluster: Cluster;
};
declare type ModalDialogsDataTypes = {
    eventsDialog: HostIdAndHostname;
    editHostDialog: EditHostProps;
    deleteHostDialog: HostIdAndHostname;
    resetHostDialog: HostIdAndHostname;
    additionalNTPSourcesDialog: void;
    resetClusterDialog: ResetClusterProps;
    cancelInstallationDialog: CancelInstallationProps;
    discoveryImageDialog: DiscoveryImageDialogProps;
};
declare type DialogId = 'eventsDialog' | 'editHostDialog' | 'deleteHostDialog' | 'resetHostDialog' | 'additionalNTPSourcesDialog' | 'resetClusterDialog' | 'cancelInstallationDialog' | 'discoveryImageDialog';
export declare type ModalDialogsContextType = {
    [key in DialogId]: {
        isOpen: boolean;
        open: (data: ModalDialogsDataTypes[key]) => void;
        close: () => void;
        data: ModalDialogsDataTypes[key];
    };
};
declare const ModalDialogsContextProvider: React.FC;
declare const useModalDialogsContext: () => ModalDialogsContextType;
export { ModalDialogsContextProvider, useModalDialogsContext };
