import { HostRoleUpdateParams, HostValidationId } from '../api/types';
export declare type Validation = {
    id: HostValidationId;
    status: 'success' | 'failure' | 'pending' | 'disabled' | 'error';
    message: string;
};
export declare type ValidationGroup = 'hardware' | 'network' | 'operators' | 'infrastructure';
export declare type ValidationsInfo = {
    [key in ValidationGroup]?: Validation[];
};
export declare type HostRole = {
    value: HostRoleUpdateParams;
    label: string;
    description: string;
};
