import * as React from 'react';
import { TextInputTypes, FormSelectOptionProps, SelectOptionProps } from '@patternfly/react-core';
import { FieldValidator, FieldHelperProps } from 'formik';
import { DropzoneProps, DropFileEventHandler } from 'react-dropzone';
import { CodeEditorProps } from '@patternfly/react-code-editor';
export interface FieldProps {
    name: string;
    label?: React.ReactNode;
    labelIcon?: React.ReactElement;
    helperText?: React.ReactNode;
    isRequired?: boolean;
    style?: React.CSSProperties;
    isReadOnly?: boolean;
    disableDeleteRow?: boolean;
    disableAddRow?: boolean;
    className?: string;
    groupClassName?: string;
    isDisabled?: boolean;
    ref?: React.Ref<any>;
    validate?: FieldValidator;
    min?: number;
    max?: number;
    idPostfix?: string;
}
export interface SelectFieldProps extends FieldProps {
    options: FormSelectOptionProps[];
    onChange?: (event: React.FormEvent<HTMLSelectElement>) => void;
    getHelperText?: (value: string) => React.ReactNode | undefined;
}
export declare type MultiSelectOption = SelectOptionProps & {
    id: string;
    displayName: string;
};
export interface MultiSelectFieldProps extends FieldProps {
    options: MultiSelectOption[];
    placeholderText?: string;
    onChange?: (val: string[]) => void;
    getHelperText?: (value: string) => React.ReactNode | undefined;
}
export interface SwitchFieldProps extends FieldProps {
    onChangeCustomOverride?: (checked: boolean, event: React.FormEvent<HTMLInputElement>) => void;
    onChange?: (checked: boolean, event: React.FormEvent<HTMLInputElement>) => void;
    getHelperText?: (value: string) => string | undefined;
}
export interface InputFieldProps extends FieldProps {
    type?: TextInputTypes;
    placeholder?: string;
    noDefaultOnChange?: boolean;
    onChange?: (event: React.FormEvent<HTMLInputElement>) => void;
    onBlur?: (event: React.FocusEvent<HTMLInputElement>) => void;
    validate?: FieldValidator;
}
export interface NumberInputFieldProps extends FieldProps {
    minValue?: number;
    maxValue?: number;
    minusBtnAriaLabel?: string;
    plusBtnAriaLabel?: string;
    unit?: string;
    formatValue?: (newValue: number) => number;
    onChange?: (event: React.FormEvent<HTMLInputElement>) => void;
    onBlur?: (event: React.FocusEvent<HTMLInputElement>) => void;
    validate?: FieldValidator;
}
export interface TextAreaFieldProps extends FieldProps {
    getErrorText?: (error: string) => React.ReactNode | undefined;
    placeholder?: string;
    onChange?: (event: React.FormEvent<HTMLTextAreaElement>) => void;
    onBlur?: (event: React.FormEvent<HTMLTextAreaElement>) => void;
    spellCheck?: boolean;
    rows?: number;
}
export interface UploadFieldProps extends FieldProps {
    getErrorText?: (error: string) => React.ReactNode | undefined;
    placeholder?: string;
    onChange?: (event: React.FormEvent<HTMLTextAreaElement>) => void;
    onBlur?: (event: React.FocusEvent<HTMLDivElement>) => void;
    allowEdittingUploadedText?: boolean;
    dropzoneProps?: Omit<DropzoneProps, 'onDropRejected'> & {
        onDropRejected?: (helpers: FieldHelperProps<string>) => DropFileEventHandler;
    };
}
export interface TextAreaSecretProps extends TextAreaFieldProps {
    isSet?: boolean;
    isEdit: boolean;
    helperTextHidden?: string;
    onToggle: (isHidden: boolean) => void;
}
export interface CheckboxFieldProps extends FieldProps {
    onChange?: (value: boolean, event: React.FormEvent<HTMLInputElement>) => void;
}
export interface SearchInputFieldProps extends InputFieldProps {
    onSearch: (searchTerm: string) => void;
}
export interface DropdownFieldProps extends FieldProps {
    items?: object;
    selectedKey?: string;
    title?: React.ReactNode;
    fullWidth?: boolean;
    disabled?: boolean;
    onChange?: (value: string) => void;
}
export interface CodeFieldProps extends FieldProps {
    language: CodeEditorProps['language'];
    description?: React.ReactNode;
}
