import { InfraEnvK8sResource, SecretK8sResource } from '../../types';
import { INFRAENV_AGENTINSTALL_LABEL_KEY } from '../common';
export declare const getBareMetalHostCredentialsSecret: (values: {
    username: string;
    password: string;
    hostname: string;
}, namespace: string) => {
    apiVersion: string;
    kind: string;
    data: {
        username: string;
        password: string;
    };
    metadata: {
        generateName: string;
        namespace: string;
    };
    type: string;
};
export declare const getBareMetalHost: (values: {
    hostname: string;
    bmcAddress: string;
    disableCertificateVerification: boolean;
    bootMACAddress: string;
    online: boolean;
}, infraEnv: InfraEnvK8sResource, secret: SecretK8sResource) => {
    apiVersion: string;
    kind: string;
    metadata: {
        name: string;
        namespace: string | undefined;
        labels: {
            "infraenvs.agent-install.openshift.io": string | undefined;
        };
        annotations: {
            'inspect.metal3.io': string;
        };
    };
    spec: {
        bmc: {
            address: string;
            credentialsName: string | undefined;
            disableCertificateVerification: boolean;
        };
        bootMACAddress: string;
        description: string;
        online: boolean;
        automatedCleaningMode: string;
    };
};
