import * as React from 'react';
import './infra-env.css';
export declare type EnvironmentStepFormValues = {
    name: string;
    location: string;
    pullSecret: string;
    sshPublicKey: string;
    httpProxy: string;
    httpsProxy: string;
    noProxy: string;
    enableProxy: boolean;
    labels: string[];
    networkType: 'dhcp' | 'static';
};
declare type InfraEnvFormProps = {
    onValuesChanged?: (values: EnvironmentStepFormValues) => void;
};
declare type InfraEnvFormPageProps = InfraEnvFormProps & {
    usedNames: string[];
    isBMPlatform: boolean;
    onSubmit?: (values: EnvironmentStepFormValues) => Promise<any>;
    onFinish?: (values: EnvironmentStepFormValues) => void;
    onClose?: VoidFunction;
};
export declare const InfraEnvFormPage: React.FC<InfraEnvFormPageProps>;
export {};
