"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.zhCN = exports.viVN = exports.ukUA = exports.trTR = exports.svSE = exports.skSK = exports.ruRU = exports.roRO = exports.ptPT = exports.ptBR = exports.plPL = exports.nlNL = exports.koKR = exports.jaJP = exports.itIT = exports.isIS = exports.idID = exports.hyAM = exports.huHU = exports.hiIN = exports.heIL = exports.frFR = exports.fiFI = exports.faIR = exports.etEE = exports.esES = exports.enUS = exports.deDE = exports.csCZ = exports.caES = exports.bgBG = exports.azAZ = void 0;
var azAZ = {
  props: {
    MuiBreadcrumbs: {
      expandText: 'Yolu göstər'
    },
    MuiTablePagination: {
      backIconButtonText: 'Əvvəlki səhifə',
      labelRowsPerPage: 'Səhifəyə düşən sətrlər:',
      labelDisplayedRows: function labelDisplayedRows(_ref) {
        var from = _ref.from,
            to = _ref.to,
            count = _ref.count;
        return "".concat(from, "-").concat(to, " d\u0259n ").concat(count !== -1 ? count : "more than ".concat(to));
      },
      nextIconButtonText: 'Növbəti səhifə'
    },
    MuiRating: {
      getLabelText: function getLabelText(value) {
        var pluralForm = 'Ulduz';
        var lastDigit = value % 10;

        if (lastDigit > 1 && lastDigit < 5) {
          pluralForm = 'Ulduzlar';
        }

        return "".concat(value, " ").concat(pluralForm);
      },
      emptyLabelText: 'Boş'
    },
    MuiAutocomplete: {
      clearText: 'Silmək',
      closeText: 'Bağlamaq',
      loadingText: 'Yüklənir…',
      noOptionsText: 'Seçimlər mövcud deyil',
      openText: 'Открыть'
    },
    MuiAlert: {
      closeText: 'Bağlamaq'
    },
    MuiPagination: {
      'aria-label': 'Səhifənin naviqasiyası',
      getItemAriaLabel: function getItemAriaLabel(type, page, selected) {
        if (type === 'page') {
          return "".concat(page, " ").concat(selected ? 'səhifə' : 'səhifəyə keç');
        }

        if (type === 'first') {
          return 'Birinci səhifəyə keç';
        }

        if (type === 'last') {
          return 'Sonuncu səhifəyə keç';
        }

        if (type === 'next') {
          return 'Növbəti səhifəyə keç';
        }

        if (type === 'previous') {
          return 'Əvvəlki səhifəyə keç';
        }

        return undefined;
      }
    }
  }
};
exports.azAZ = azAZ;
var bgBG = {
  props: {
    MuiBreadcrumbs: {
      expandText: 'Показване на пътя'
    },
    MuiTablePagination: {
      backIconButtonText: 'Предишна страница',
      labelRowsPerPage: 'Редове на страница:',
      labelDisplayedRows: function labelDisplayedRows(_ref2) {
        var from = _ref2.from,
            to = _ref2.to,
            count = _ref2.count;
        return "".concat(from, "-").concat(to, " \u043E\u0442 ").concat(count !== -1 ? count : "more than ".concat(to));
      },
      nextIconButtonText: 'Следваща страница'
    },
    MuiRating: {
      getLabelText: function getLabelText(value) {
        return "".concat(value, " \u0417\u0432\u0435\u0437\u0434").concat(value !== 1 ? 'и' : 'а');
      },
      emptyLabelText: 'Изчисти'
    },
    MuiAutocomplete: {
      clearText: 'Изчисти',
      closeText: 'Затвори',
      loadingText: 'Зареждане…',
      noOptionsText: 'Няма налични опции',
      openText: 'Отвори'
    },
    MuiAlert: {
      closeText: 'Затвори'
    },
    MuiPagination: {
      'aria-label': 'Пагинация',
      getItemAriaLabel: function getItemAriaLabel(type, page, selected) {
        if (type === 'page') {
          return "".concat(selected ? '' : 'Към ', "\u0441\u0442\u0440\u0430\u043D\u0438\u0446\u0430 ").concat(page);
        }

        if (type === 'first') {
          return 'Отиди на първата страница';
        }

        if (type === 'last') {
          return 'Отиди на последната страница';
        }

        if (type === 'next') {
          return 'Отиди на следващата страница';
        }

        if (type === 'previous') {
          return 'Отиди на предишната страница';
        }

        return undefined;
      }
    }
  }
};
exports.bgBG = bgBG;
var caES = {
  props: {
    // MuiBreadcrumbs: {
    //   expandText: 'Show path',
    // },
    MuiTablePagination: {
      backIconButtonText: 'Pàgina anterior',
      labelRowsPerPage: 'Files per pàgina:',
      labelDisplayedRows: function labelDisplayedRows(_ref3) {
        var from = _ref3.from,
            to = _ref3.to,
            count = _ref3.count;
        return "".concat(from, "-").concat(to, " de ").concat(count !== -1 ? count : "more than ".concat(to));
      },
      nextIconButtonText: 'Següent pàgina'
    },
    MuiRating: {
      getLabelText: function getLabelText(value) {
        return "".concat(value, " ").concat(value !== 1 ? 'Estrelles' : 'Estrella');
      },
      emptyLabelText: 'Buit'
    },
    MuiAutocomplete: {
      clearText: 'Netejar',
      closeText: 'Tancar',
      loadingText: 'Carregant…',
      noOptionsText: 'Sense opcions',
      openText: 'Obert'
    },
    MuiAlert: {
      closeText: 'Tancat'
    } // MuiPagination: {
    //   'aria-label': 'Pagination navigation',
    //   getItemAriaLabel: (type, page, selected) => {
    //     if (type === 'page') {
    //       return `${selected ? '' : 'Go to '}page ${page}`;
    //     }
    //     if (type === 'first') {
    //       return 'Go to first page';
    //     }
    //     if (type === 'last') {
    //       return 'Go to last page';
    //     }
    //     if (type === 'next') {
    //       return 'Go to next page';
    //     }
    //     if (type === 'previous') {
    //       return 'Go to previous page';
    //     }
    //     return undefined;
    //   },
    // },

  }
};
exports.caES = caES;
var csCZ = {
  props: {
    MuiBreadcrumbs: {
      expandText: 'Ukázat cestu'
    },
    MuiTablePagination: {
      backIconButtonText: 'Předchozí stránka',
      labelRowsPerPage: 'Řádků na stránce:',
      labelDisplayedRows: function labelDisplayedRows(_ref4) {
        var from = _ref4.from,
            to = _ref4.to,
            count = _ref4.count;
        return "".concat(from, "-").concat(to, " z ").concat(count !== -1 ? count : "more than ".concat(to));
      },
      nextIconButtonText: 'Další stránka'
    },
    MuiRating: {
      getLabelText: function getLabelText(value) {
        if (value === 1) {
          return "".concat(value, " hv\u011Bzdi\u010Dka");
        }

        if (value >= 2 && value <= 4) {
          return "".concat(value, " hv\u011Bzdi\u010Dky");
        }

        return "".concat(value, " hv\u011Bzdi\u010Dek");
      },
      emptyLabelText: 'Prázdné'
    },
    MuiAutocomplete: {
      clearText: 'Vymazat',
      closeText: 'Zavřít',
      loadingText: 'Načítání…',
      noOptionsText: 'Žádné možnosti',
      openText: 'Otevřít'
    },
    MuiAlert: {
      closeText: 'Zavřít'
    },
    MuiPagination: {
      'aria-label': 'Navigace stránkováním',
      getItemAriaLabel: function getItemAriaLabel(type, page, selected) {
        if (type === 'page') {
          return "".concat(selected ? '' : 'Jít na ').concat(page, " str\xE1nku");
        }

        if (type === 'first') {
          return 'Jít na první stránku';
        }

        if (type === 'last') {
          return 'Jít na poslední stránku';
        }

        if (type === 'next') {
          return 'Jít na další stránku';
        }

        if (type === 'previous') {
          return 'Jít na předchozí stránku';
        }

        return undefined;
      }
    }
  }
};
exports.csCZ = csCZ;
var deDE = {
  props: {
    MuiBreadcrumbs: {
      expandText: 'Pfad anzeigen'
    },
    MuiTablePagination: {
      backIconButtonText: 'Nächste Seite',
      labelRowsPerPage: 'Zeilen pro Seite:',
      labelDisplayedRows: function labelDisplayedRows(_ref5) {
        var from = _ref5.from,
            to = _ref5.to,
            count = _ref5.count;
        return "".concat(from, "-").concat(to, " von ").concat(count !== -1 ? count : "more than ".concat(to));
      },
      nextIconButtonText: 'Nächste Seite'
    },
    MuiRating: {
      getLabelText: function getLabelText(value) {
        return "".concat(value, " ").concat(value !== 1 ? 'Sterne' : 'Stern');
      },
      emptyLabelText: 'Keine Wertung'
    },
    MuiAutocomplete: {
      clearText: 'Leeren',
      closeText: 'Schließen',
      loadingText: 'Wird geladen…',
      noOptionsText: 'Keine Optionen',
      openText: 'Öffnen'
    },
    MuiAlert: {
      closeText: 'Schließen'
    },
    MuiPagination: {
      'aria-label': 'Navigation via Seitennummerierung',
      getItemAriaLabel: function getItemAriaLabel(type, page, selected) {
        if (type === 'page') {
          return "".concat(selected ? '' : 'Gehe zu ', "Seite ").concat(page);
        }

        if (type === 'first') {
          return 'Zur ersten Seite';
        }

        if (type === 'last') {
          return 'Zur letzten Seite';
        }

        if (type === 'next') {
          return 'Zur nächsten Seite';
        }

        if (type === 'previous') {
          return 'Zur vorherigen Seite';
        }

        return undefined;
      }
    }
  }
}; // default

exports.deDE = deDE;
var enUS = {
  /*
  props: {
    MuiBreadcrumbs: {
      expandText: 'Show path',
    },
    MuiTablePagination: {
      backIconButtonText: 'Previous page',
      labelRowsPerPage: 'Rows per page:',
      labelDisplayedRows: ({ from, to, count }) =>
  `${from}-${to} of ${count !== -1 ? count : `more than ${to}`}`,
      nextIconButtonText: 'Next page',
    },
    MuiRating: {
      getLabelText: value => `${value} Star${value !== 1 ? 's' : ''}`,
      emptyLabelText: 'Empty',
    },
    MuiAutocomplete: {
      clearText: 'Clear',
      closeText: 'Close',
      loadingText: 'Loading…',
      noOptionsText: 'No options',
      openText: 'Open',
    },
    MuiAlert: {
      closeText: 'Close',
    },
    MuiPagination: {
      'aria-label': 'Pagination navigation',
      getItemAriaLabel: (type, page, selected) => {
        if (type === 'page') {
          return `${selected ? '' : 'Go to '}page ${page}`;
        }
        if (type === 'first') {
          return 'Go to first page';
        }
        if (type === 'last') {
          return 'Go to last page';
        }
        if (type === 'next') {
          return 'Go to next page';
        }
        if (type === 'previous') {
          return 'Go to previous page';
        }
        return undefined;
      },
    },
  },
  */
};
exports.enUS = enUS;
var esES = {
  props: {
    MuiBreadcrumbs: {
      expandText: 'Mostrar ruta'
    },
    MuiTablePagination: {
      backIconButtonText: 'Página anterior',
      labelRowsPerPage: 'Filas por página:',
      labelDisplayedRows: function labelDisplayedRows(_ref6) {
        var from = _ref6.from,
            to = _ref6.to,
            count = _ref6.count;
        return "".concat(from, "-").concat(to, " de ").concat(count !== -1 ? count : "more than ".concat(to));
      },
      nextIconButtonText: 'Siguiente página'
    },
    MuiRating: {
      getLabelText: function getLabelText(value) {
        return "".concat(value, " Estrella").concat(value !== 1 ? 's' : '');
      },
      emptyLabelText: 'Vacío'
    },
    MuiAutocomplete: {
      clearText: 'Limpiar',
      closeText: 'Cerrar',
      loadingText: 'Cargando…',
      noOptionsText: 'Sin opciones',
      openText: 'Abierto'
    },
    MuiAlert: {
      closeText: 'Cerrar'
    },
    MuiPagination: {
      'aria-label': 'Paginador',
      getItemAriaLabel: function getItemAriaLabel(type, page, selected) {
        if (type === 'page') {
          return "".concat(selected ? '' : 'Ir a la ', "p\xE1gina ").concat(page);
        }

        if (type === 'first') {
          return 'Ir a la primera página';
        }

        if (type === 'last') {
          return 'Ir a la última página';
        }

        if (type === 'next') {
          return 'Ir a la página siguiente';
        }

        if (type === 'previous') {
          return 'Ir a la página anterior';
        }

        return undefined;
      }
    }
  }
};
exports.esES = esES;
var etEE = {
  props: {
    MuiBreadcrumbs: {
      expandText: 'Näita teed'
    },
    MuiTablePagination: {
      backIconButtonText: 'Eelmine lehekülg',
      labelRowsPerPage: 'Ridu leheküljel:',
      labelDisplayedRows: function labelDisplayedRows(_ref7) {
        var from = _ref7.from,
            to = _ref7.to,
            count = _ref7.count;
        return "".concat(from, "-").concat(to, " / ").concat(count !== -1 ? count : "more than ".concat(to));
      },
      nextIconButtonText: 'Järgmine lehekülg'
    },
    MuiRating: {
      getLabelText: function getLabelText(value) {
        return "".concat(value, " T\xE4rn").concat(value !== 1 ? 'i' : '');
      },
      emptyLabelText: 'Tühi'
    },
    MuiAutocomplete: {
      clearText: 'Tühjenda',
      closeText: 'Sulge',
      loadingText: 'Laen…',
      noOptionsText: 'Valikuid ei ole',
      openText: 'Ava'
    },
    MuiAlert: {
      closeText: 'Sulge'
    },
    MuiPagination: {
      'aria-label': 'Lehekülgede valik',
      getItemAriaLabel: function getItemAriaLabel(type, page, selected) {
        if (type === 'page') {
          return "".concat(selected ? '' : 'Vali ', "lehek\xFClg ").concat(page);
        }

        if (type === 'first') {
          return 'Vali esimene lehekülg';
        }

        if (type === 'last') {
          return 'Vali viimane lehekülg';
        }

        if (type === 'next') {
          return 'Vali järgmine lehekülg';
        }

        if (type === 'previous') {
          return 'Vali eelmine lehekülg';
        }

        return undefined;
      }
    }
  }
};
exports.etEE = etEE;
var faIR = {
  props: {
    // MuiBreadcrumbs: {
    //   expandText: 'Show path',
    // },
    MuiBreadcrumbs: {
      expandText: 'نمایش مسیر'
    },
    MuiTablePagination: {
      backIconButtonText: 'صفحهٔ قبل',
      labelRowsPerPage: 'تعداد سطرهای هر صفحه:',
      labelDisplayedRows: function labelDisplayedRows(_ref8) {
        var from = _ref8.from,
            to = _ref8.to,
            count = _ref8.count;
        return "".concat(from, "-").concat(to, " \u0627\u0632 ").concat(count !== -1 ? count : "more than ".concat(to));
      },
      nextIconButtonText: 'صفحهٔ بعد'
    },
    MuiRating: {
      getLabelText: function getLabelText(value) {
        return "".concat(value, " \u0633\u062A\u0627\u0631\u0647");
      },
      emptyLabelText: 'خالی'
    },
    MuiAutocomplete: {
      clearText: 'پاک‌کردن',
      closeText: 'بستن',
      loadingText: 'در حال بارگذاری…',
      noOptionsText: 'بی‌نتیجه',
      openText: 'بازکردن'
    },
    MuiAlert: {
      closeText: 'بستن'
    },
    MuiPagination: {
      'aria-label': 'ناوبری صفحه',
      getItemAriaLabel: function getItemAriaLabel(type, page, selected) {
        if (type === 'page') {
          return "".concat(selected ? '' : 'رفتن به ', "\u0635\u0641\u062D\u0647\u0654 ").concat(page);
        }

        if (type === 'first') {
          return 'رفتن به اولین صفحه';
        }

        if (type === 'last') {
          return 'رفتن به آخرین صفحه';
        }

        if (type === 'next') {
          return 'رفتن به صفحه‌ی بعدی';
        }

        if (type === 'previous') {
          return 'رفتن به صفحه‌ی قبلی';
        }

        return undefined;
      }
    }
  }
};
exports.faIR = faIR;
var fiFI = {
  props: {
    MuiBreadcrumbs: {
      expandText: 'Näytä reitti'
    },
    MuiTablePagination: {
      backIconButtonText: 'Edellinen sivu',
      labelRowsPerPage: 'Rivejä per sivu:',
      labelDisplayedRows: function labelDisplayedRows(_ref9) {
        var from = _ref9.from,
            to = _ref9.to,
            count = _ref9.count;
        return "".concat(from, "-").concat(to, " / ").concat(count !== -1 ? count : "more than ".concat(to));
      },
      nextIconButtonText: 'Seuraava sivu'
    },
    MuiRating: {
      getLabelText: function getLabelText(value) {
        return "".concat(value, " T\xE4ht").concat(value !== 1 ? 'eä' : 'i');
      },
      emptyLabelText: 'Tyhjä'
    },
    MuiAutocomplete: {
      clearText: 'Tyhjennä',
      closeText: 'Sulje',
      loadingText: 'Ladataan…',
      noOptionsText: 'Ei valintoja',
      openText: 'Avaa'
    },
    MuiAlert: {
      closeText: 'Sulje'
    },
    MuiPagination: {
      'aria-label': 'Sivutus navigaatio',
      getItemAriaLabel: function getItemAriaLabel(type, page, selected) {
        if (type === 'page') {
          return "".concat(selected ? 'sivu' : 'Mene sivulle', " ").concat(page);
        }

        if (type === 'first') {
          return 'Mene ensimmäiselle sivulle';
        }

        if (type === 'last') {
          return 'Mene viimeiselle sivulle';
        }

        if (type === 'next') {
          return 'Mene seuraavalle sivulle';
        }

        if (type === 'previous') {
          return 'Mene edelliselle sivulle';
        }

        return undefined;
      }
    }
  }
};
exports.fiFI = fiFI;
var frFR = {
  props: {
    MuiBreadcrumbs: {
      expandText: 'Montrer le chemin'
    },
    MuiTablePagination: {
      backIconButtonText: 'Page précédente',
      labelRowsPerPage: 'Lignes par page :',
      labelDisplayedRows: function labelDisplayedRows(_ref10) {
        var from = _ref10.from,
            to = _ref10.to,
            count = _ref10.count;
        return "".concat(from, "-").concat(to, " sur ").concat(count !== -1 ? count : "plus que ".concat(to));
      },
      nextIconButtonText: 'Page suivante'
    },
    MuiRating: {
      getLabelText: function getLabelText(value) {
        return "".concat(value, " Etoile").concat(value !== 1 ? 's' : '');
      },
      emptyLabelText: 'Vide'
    },
    MuiAutocomplete: {
      clearText: 'Vider',
      closeText: 'Fermer',
      loadingText: 'Chargement…',
      noOptionsText: 'Pas de résultats',
      openText: 'Ouvrir'
    },
    MuiAlert: {
      closeText: 'Fermer'
    },
    MuiPagination: {
      'aria-label': 'navigation de pagination',
      getItemAriaLabel: function getItemAriaLabel(type, page, selected) {
        if (type === 'page') {
          return "".concat(selected ? '' : 'Aller à la ', "page ").concat(page);
        }

        if (type === 'first') {
          return 'Aller à la première page';
        }

        if (type === 'last') {
          return 'Aller à la dernière page';
        }

        if (type === 'next') {
          return 'Aller à la page suivante';
        }

        if (type === 'previous') {
          return 'Aller à la page précédente';
        }

        return undefined;
      }
    }
  }
};
exports.frFR = frFR;
var heIL = {
  props: {
    // MuiBreadcrumbs: {
    //   expandText: 'Show path',
    // },
    MuiTablePagination: {
      backIconButtonText: 'העמוד הקודם',
      labelRowsPerPage: 'שורות בעמוד:',
      labelDisplayedRows: function labelDisplayedRows(_ref11) {
        var from = _ref11.from,
            to = _ref11.to,
            count = _ref11.count;
        return "".concat(from, "-").concat(to, " \u05DE\u05EA\u05D5\u05DA ").concat(count !== -1 ? count : "more than ".concat(to));
      },
      nextIconButtonText: 'העמוד הבא'
    },
    MuiRating: {
      getLabelText: function getLabelText(value) {
        return "".concat(value, " \u05DB\u05D5\u05DB\u05D1").concat(value !== 1 ? 'ים' : '');
      },
      emptyLabelText: 'ריק'
    },
    MuiAutocomplete: {
      clearText: 'נקה',
      closeText: 'סגור',
      loadingText: 'טוען…',
      noOptionsText: 'אין אופציות',
      openText: 'פתח'
    },
    MuiAlert: {
      closeText: 'סגור'
    } // MuiPagination: {
    //   'aria-label': 'Pagination navigation',
    //   getItemAriaLabel: (type, page, selected) => {
    //     if (type === 'page') {
    //       return `${selected ? '' : 'Go to '}page ${page}`;
    //     }
    //     if (type === 'first') {
    //       return 'Go to first page';
    //     }
    //     if (type === 'last') {
    //       return 'Go to last page';
    //     }
    //     if (type === 'next') {
    //       return 'Go to next page';
    //     }
    //     if (type === 'previous') {
    //       return 'Go to previous page';
    //     }
    //     return undefined;
    //   },
    // },

  }
};
exports.heIL = heIL;
var hiIN = {
  props: {
    MuiBreadcrumbs: {
      expandText: 'रास्ता दिखायें'
    },
    MuiTablePagination: {
      backIconButtonText: 'पिछला पृष्ठ',
      labelRowsPerPage: 'पंक्तियाँ प्रति पृष्ठ:',
      labelDisplayedRows: function labelDisplayedRows(_ref12) {
        var from = _ref12.from,
            to = _ref12.to,
            count = _ref12.count;
        return "".concat(from, "-").concat(to === -1 ? count : to, " \u0915\u0941\u0932 ").concat(count, " \u092E\u0947\u0902");
      },
      nextIconButtonText: 'अगला पृष्ठ'
    },
    MuiRating: {
      getLabelText: function getLabelText(value) {
        return "".concat(value, " \u0924\u093E\u0930").concat(value !== 1 ? 'े' : 'ा');
      },
      emptyLabelText: 'रिक्त'
    },
    MuiAutocomplete: {
      clearText: 'हटायें',
      closeText: 'बंद करें',
      loadingText: 'लोड हो रहा है…',
      noOptionsText: 'कोई विकल्प नहीं',
      openText: 'खोलें'
    },
    MuiAlert: {
      closeText: 'बंद करें'
    },
    MuiPagination: {
      'aria-label': 'पृस्ठानुसार संचालन',
      getItemAriaLabel: function getItemAriaLabel(type, page, selected) {
        if (type === 'page') {
          return "\u092A\u0943\u0937\u094D\u0920 ".concat(page, " ").concat(selected ? '' : ' पर जाएँ');
        }

        if (type === 'first') {
          return 'पहले पृष्ठ पर जाएँ';
        }

        if (type === 'last') {
          return 'अंतिम पृष्ठ पर जाएँ';
        }

        if (type === 'next') {
          return 'अगले पृष्ठ पर जाएँ';
        }

        if (type === 'previous') {
          return 'पिछले पृष्ठ पर जाएँ';
        }

        return undefined;
      }
    }
  }
};
exports.hiIN = hiIN;
var huHU = {
  props: {
    MuiBreadcrumbs: {
      expandText: 'Útvonal'
    },
    MuiTablePagination: {
      backIconButtonText: 'Előző oldal',
      labelRowsPerPage: 'Sorok száma:',
      labelDisplayedRows: function labelDisplayedRows(_ref13) {
        var from = _ref13.from,
            to = _ref13.to,
            count = _ref13.count;
        return "".concat(from, "-").concat(to, " / ").concat(count !== -1 ? count : "more than ".concat(to));
      },
      nextIconButtonText: 'Következő oldal'
    },
    MuiRating: {
      getLabelText: function getLabelText(value) {
        return "".concat(value, " Csillag");
      },
      emptyLabelText: 'Üres'
    },
    MuiAutocomplete: {
      clearText: 'Törlés',
      closeText: 'Bezárás',
      loadingText: 'Töltés…',
      noOptionsText: 'Nincs találat',
      openText: 'Megnyitás'
    },
    MuiAlert: {
      closeText: 'Bezárás'
    },
    MuiPagination: {
      'aria-label': 'Lapozás',
      getItemAriaLabel: function getItemAriaLabel(type, page, selected) {
        if (type === 'page') {
          return "".concat(page, ". oldal").concat(selected ? '' : 'ra');
        }

        if (type === 'first') {
          return 'Első oldalra';
        }

        if (type === 'last') {
          return 'Utolsó oldalra';
        }

        if (type === 'next') {
          return 'Következő oldalra';
        }

        if (type === 'previous') {
          return 'Előző oldalra';
        }

        return undefined;
      }
    }
  }
};
exports.huHU = huHU;
var hyAM = {
  props: {
    // MuiBreadcrumbs: {
    //   expandText: 'Show path',
    // },
    MuiTablePagination: {
      backIconButtonText: 'Նախորդը',
      labelRowsPerPage: 'Տողեր մեկ էջում`',
      labelDisplayedRows: function labelDisplayedRows(_ref14) {
        var from = _ref14.from,
            to = _ref14.to,
            count = _ref14.count;
        return "".concat(from, "-").concat(to, " / ").concat(count !== -1 ? count : "more than ".concat(to));
      },
      nextIconButtonText: 'Հաջորդը'
    },
    MuiRating: {
      getLabelText: function getLabelText(value) {
        return "".concat(value, " \u0531\u057D\u057F\u0572");
      },
      emptyLabelText: 'Դատարկ'
    },
    MuiAutocomplete: {
      clearText: 'Մաքրել',
      closeText: 'Փակել',
      loadingText: 'Բեռնում…',
      noOptionsText: 'Տարբերակներ չկան',
      openText: 'Բացել'
    },
    MuiAlert: {
      closeText: 'Փակել'
    } // MuiPagination: {
    //   'aria-label': 'Pagination navigation',
    //   getItemAriaLabel: (type, page, selected) => {
    //     if (type === 'page') {
    //       return `${selected ? '' : 'Go to '}page ${page}`;
    //     }
    //     if (type === 'first') {
    //       return 'Go to first page';
    //     }
    //     if (type === 'last') {
    //       return 'Go to last page';
    //     }
    //     if (type === 'next') {
    //       return 'Go to next page';
    //     }
    //     if (type === 'previous') {
    //       return 'Go to previous page';
    //     }
    //     return undefined;
    //   },
    // },

  }
};
exports.hyAM = hyAM;
var idID = {
  props: {
    // MuiBreadcrumbs: {
    //   expandText: 'Show path',
    // },
    MuiTablePagination: {
      backIconButtonText: 'Halaman sebelumnya',
      labelRowsPerPage: 'Baris per halaman:',
      labelDisplayedRows: function labelDisplayedRows(_ref15) {
        var from = _ref15.from,
            to = _ref15.to,
            count = _ref15.count;
        return "".concat(from, "-").concat(to, " dari ").concat(count !== -1 ? count : "more than ".concat(to));
      },
      nextIconButtonText: 'Halaman selanjutnya'
    },
    MuiRating: {
      getLabelText: function getLabelText(value) {
        return "".concat(value, " Bintang");
      } // emptyLabelText: 'Empty',

    },
    MuiAutocomplete: {
      clearText: 'Hapus',
      closeText: 'Tutup',
      loadingText: 'Memuat…',
      noOptionsText: 'Tidak ada opsi',
      openText: 'Buka'
    },
    MuiAlert: {
      closeText: 'Tutup'
    } // MuiPagination: {
    //   'aria-label': 'Pagination navigation',
    //   getItemAriaLabel: (type, page, selected) => {
    //     if (type === 'page') {
    //       return `${selected ? '' : 'Go to '}page ${page}`;
    //     }
    //     if (type === 'first') {
    //       return 'Go to first page';
    //     }
    //     if (type === 'last') {
    //       return 'Go to last page';
    //     }
    //     if (type === 'next') {
    //       return 'Go to next page';
    //     }
    //     if (type === 'previous') {
    //       return 'Go to previous page';
    //     }
    //     return undefined;
    //   },
    // },

  }
};
exports.idID = idID;
var isIS = {
  props: {
    // MuiBreadcrumbs: {
    //   expandText: 'Show path',
    // },
    MuiTablePagination: {
      backIconButtonText: 'Fyrri síða',
      labelRowsPerPage: 'Raðir á síðu:',
      labelDisplayedRows: function labelDisplayedRows(_ref16) {
        var from = _ref16.from,
            to = _ref16.to,
            count = _ref16.count;
        return "".concat(from, "-").concat(to, " af ").concat(count !== -1 ? count : "more than ".concat(to));
      },
      nextIconButtonText: 'Næsta síða'
    },
    MuiRating: {
      getLabelText: function getLabelText(value) {
        return "".concat(value, " ").concat(value === 1 ? 'Stjarna' : 'Stjörnur');
      },
      emptyLabelText: 'Tómt'
    },
    MuiAutocomplete: {
      clearText: 'Hreinsa',
      closeText: 'Loka',
      loadingText: 'Hlaða…',
      noOptionsText: 'Engar niðurstöður',
      openText: 'Opna'
    },
    MuiAlert: {
      closeText: 'Loka'
    } // MuiPagination: {
    //   'aria-label': 'Pagination navigation',
    //   getItemAriaLabel: (type, page, selected) => {
    //     if (type === 'page') {
    //       return `${selected ? '' : 'Go to '}page ${page}`;
    //     }
    //     if (type === 'first') {
    //       return 'Go to first page';
    //     }
    //     if (type === 'last') {
    //       return 'Go to last page';
    //     }
    //     if (type === 'next') {
    //       return 'Go to next page';
    //     }
    //     if (type === 'previous') {
    //       return 'Go to previous page';
    //     }
    //     return undefined;
    //   },
    // },

  }
};
exports.isIS = isIS;
var itIT = {
  props: {
    MuiBreadcrumbs: {
      expandText: 'Visualizza percorso'
    },
    MuiTablePagination: {
      backIconButtonText: 'Pagina precedente',
      labelRowsPerPage: 'Righe per pagina:',
      labelDisplayedRows: function labelDisplayedRows(_ref17) {
        var from = _ref17.from,
            to = _ref17.to,
            count = _ref17.count;
        return "".concat(from, "-").concat(to, " di ").concat(count !== -1 ? count : "more than ".concat(to));
      },
      nextIconButtonText: 'Pagina successiva'
    },
    MuiRating: {
      getLabelText: function getLabelText(value) {
        return "".concat(value, " Stell").concat(value !== 1 ? 'e' : 'a');
      },
      emptyLabelText: 'Vuoto'
    },
    MuiAutocomplete: {
      clearText: 'Svuota',
      closeText: 'Chiudi',
      loadingText: 'Caricamento in corso…',
      noOptionsText: 'Nessuna opzione',
      openText: 'Apri'
    },
    MuiAlert: {
      closeText: 'Chiudi'
    },
    MuiPagination: {
      'aria-label': 'Navigazione impaginata',
      getItemAriaLabel: function getItemAriaLabel(type, page, selected) {
        if (type === 'page') {
          return "".concat(selected ? '' : 'Vai alla ', "pagina ").concat(page);
        }

        if (type === 'first') {
          return 'Vai alla prima pagina';
        }

        if (type === 'last') {
          return "Vai all'ultima pagina";
        }

        if (type === 'next') {
          return 'Vai alla pagina successiva';
        }

        if (type === 'previous') {
          return 'Vai alla pagina precedente';
        }

        return undefined;
      }
    }
  }
};
exports.itIT = itIT;
var jaJP = {
  props: {
    // MuiBreadcrumbs: {
    //   expandText: 'Show path',
    // },
    MuiTablePagination: {
      backIconButtonText: '前のページ',
      labelRowsPerPage: 'ページごとの行:',
      labelDisplayedRows: function labelDisplayedRows(_ref18) {
        var from = _ref18.from,
            to = _ref18.to,
            count = _ref18.count;
        return "".concat(from, "-").concat(to, " of ").concat(count !== -1 ? count : "more than ".concat(to));
      },
      nextIconButtonText: '次のページ'
    },
    MuiRating: {
      getLabelText: function getLabelText(value) {
        return "".concat(value, " ").concat(value !== 1 ? '出演者' : '星');
      } // emptyLabelText: 'Empty',

    },
    MuiAutocomplete: {
      clearText: 'クリア',
      closeText: '閉じる',
      loadingText: '積み込み…',
      noOptionsText: '結果がありません',
      openText: '開いた'
    },
    MuiAlert: {
      closeText: '閉じる'
    } // MuiPagination: {
    //   'aria-label': 'Pagination navigation',
    //   getItemAriaLabel: (type, page, selected) => {
    //     if (type === 'page') {
    //       return `${selected ? '' : 'Go to '}page ${page}`;
    //     }
    //     if (type === 'first') {
    //       return 'Go to first page';
    //     }
    //     if (type === 'last') {
    //       return 'Go to last page';
    //     }
    //     if (type === 'next') {
    //       return 'Go to next page';
    //     }
    //     if (type === 'previous') {
    //       return 'Go to previous page';
    //     }
    //     return undefined;
    //   },
    // },

  }
};
exports.jaJP = jaJP;
var koKR = {
  props: {
    // MuiBreadcrumbs: {
    //   expandText: 'Show path',
    // },
    MuiTablePagination: {
      backIconButtonText: '이전 페이지',
      labelRowsPerPage: '페이지 당 행:',
      labelDisplayedRows: function labelDisplayedRows(_ref19) {
        var from = _ref19.from,
            to = _ref19.to,
            count = _ref19.count;
        return "".concat(from, "-").concat(to, " / ").concat(count !== -1 ? count : "more than ".concat(to));
      },
      nextIconButtonText: '다음 페이지'
    },
    MuiRating: {
      getLabelText: function getLabelText(value) {
        return "".concat(value, " \uC810");
      } // emptyLabelText: 'Empty',

    },
    MuiAutocomplete: {
      clearText: '지우기',
      closeText: '닫기',
      loadingText: '불러오는 중…',
      noOptionsText: '옵션 없음',
      openText: '열기'
    }
  }
};
exports.koKR = koKR;
var nlNL = {
  props: {
    // MuiBreadcrumbs: {
    //   expandText: 'Show path',
    // },
    MuiTablePagination: {
      backIconButtonText: 'Vorige pagina',
      labelRowsPerPage: 'Regels per pagina :',
      labelDisplayedRows: function labelDisplayedRows(_ref20) {
        var from = _ref20.from,
            to = _ref20.to,
            count = _ref20.count;
        return "".concat(from, "-").concat(to, " van ").concat(count !== -1 ? count : "more than ".concat(to));
      },
      nextIconButtonText: 'Volgende pagina'
    },
    MuiRating: {
      getLabelText: function getLabelText(value) {
        return "".concat(value, " Ster").concat(value !== 1 ? 'ren' : '');
      } // emptyLabelText: 'Empty',

    },
    MuiAutocomplete: {
      clearText: 'Wissen',
      closeText: 'Sluiten',
      loadingText: 'Laden…',
      noOptionsText: 'Geen opties',
      openText: 'Openen'
    },
    MuiAlert: {
      closeText: 'Sluiten'
    } // MuiPagination: {
    //   'aria-label': 'Pagination navigation',
    //   getItemAriaLabel: (type, page, selected) => {
    //     if (type === 'page') {
    //       return `${selected ? '' : 'Go to '}page ${page}`;
    //     }
    //     if (type === 'first') {
    //       return 'Go to first page';
    //     }
    //     if (type === 'last') {
    //       return 'Go to last page';
    //     }
    //     if (type === 'next') {
    //       return 'Go to next page';
    //     }
    //     if (type === 'previous') {
    //       return 'Go to previous page';
    //     }
    //     return undefined;
    //   },
    // },

  }
};
exports.nlNL = nlNL;
var plPL = {
  props: {
    MuiBreadcrumbs: {
      expandText: 'Pokaż ścieżkę'
    },
    MuiTablePagination: {
      backIconButtonText: 'Poprzednia strona',
      labelRowsPerPage: 'Wierszy na stronę:',
      labelDisplayedRows: function labelDisplayedRows(_ref21) {
        var from = _ref21.from,
            to = _ref21.to,
            count = _ref21.count;
        return "".concat(from, "-").concat(to, " z ").concat(count !== -1 ? count : "more than ".concat(to));
      },
      nextIconButtonText: 'Następna strona'
    },
    MuiRating: {
      getLabelText: function getLabelText(value) {
        var pluralForm = 'gwiazdek';
        var lastDigit = value % 10;

        if ((value < 10 || value > 20) && lastDigit > 1 && lastDigit < 5) {
          pluralForm = 'gwiazdki';
        } else if (value === 1) {
          pluralForm = 'gwiazdka';
        }

        return "".concat(value, " ").concat(pluralForm);
      },
      emptyLabelText: 'Brak gwiazdek'
    },
    MuiAutocomplete: {
      clearText: 'Wyczyść',
      closeText: 'Zamknij',
      loadingText: 'Ładowanie…',
      noOptionsText: 'Brak opcji',
      openText: 'Otwórz'
    },
    MuiAlert: {
      closeText: 'Zamknij'
    },
    MuiPagination: {
      'aria-label': 'Nawigacja podziału na strony',
      getItemAriaLabel: function getItemAriaLabel(type, page, selected) {
        if (type === 'page') {
          return selected ? "".concat(page, ". strona") : "Przejd\u017A do ".concat(page, ". strony");
        }

        if (type === 'first') {
          return 'Przejdź do pierwszej strony';
        }

        if (type === 'last') {
          return 'Przejdź do ostatniej strony';
        }

        if (type === 'next') {
          return 'Przejdź do następnej strony';
        }

        if (type === 'previous') {
          return 'Przejdź do poprzedniej strony';
        }

        return undefined;
      }
    }
  }
};
exports.plPL = plPL;
var ptBR = {
  props: {
    MuiBreadcrumbs: {
      expandText: 'Mostrar caminho'
    },
    MuiTablePagination: {
      backIconButtonText: 'Página anterior',
      labelRowsPerPage: 'Linhas por página:',
      labelDisplayedRows: function labelDisplayedRows(_ref22) {
        var from = _ref22.from,
            to = _ref22.to,
            count = _ref22.count;
        return "".concat(from, "-").concat(to, " de ").concat(count !== -1 ? count : "more than ".concat(to));
      },
      nextIconButtonText: 'Próxima página'
    },
    MuiRating: {
      getLabelText: function getLabelText(value) {
        return "".concat(value, " Estrela").concat(value !== 1 ? 's' : '');
      },
      emptyLabelText: 'Vazio'
    },
    MuiAutocomplete: {
      clearText: 'Limpar',
      closeText: 'Fechar',
      loadingText: 'Carregando…',
      noOptionsText: 'Sem opções',
      openText: 'Abrir'
    },
    MuiAlert: {
      closeText: 'Fechar'
    },
    MuiPagination: {
      'aria-label': 'Navegar pela paginação',
      getItemAriaLabel: function getItemAriaLabel(type, page, selected) {
        if (type === 'page') {
          return "".concat(selected ? '' : 'Ir para a ', "p\xE1gina ").concat(page);
        }

        if (type === 'first') {
          return 'Ir para a primeira página';
        }

        if (type === 'last') {
          return 'Ir para a última página';
        }

        if (type === 'next') {
          return 'Ir para a próxima página';
        }

        if (type === 'previous') {
          return 'Ir para a página anterior';
        }

        return undefined;
      }
    }
  }
};
exports.ptBR = ptBR;
var ptPT = {
  props: {
    MuiBreadcrumbs: {
      expandText: 'Mostrar caminho'
    },
    MuiTablePagination: {
      backIconButtonText: 'Página anterior',
      labelRowsPerPage: 'Linhas por página:',
      labelDisplayedRows: function labelDisplayedRows(_ref23) {
        var from = _ref23.from,
            to = _ref23.to,
            count = _ref23.count;
        return "".concat(from, "-").concat(to, " de ").concat(count !== -1 ? count : "more than ".concat(to));
      },
      nextIconButtonText: 'Próxima página'
    },
    MuiRating: {
      getLabelText: function getLabelText(value) {
        return "".concat(value, " Estrela").concat(value !== 1 ? 's' : '');
      },
      emptyLabelText: 'Vazio'
    },
    MuiAutocomplete: {
      clearText: 'Limpar',
      closeText: 'Fechar',
      loadingText: 'A carregar…',
      noOptionsText: 'Sem opções',
      openText: 'Abrir'
    },
    MuiAlert: {
      closeText: 'Fechar'
    },
    MuiPagination: {
      'aria-label': 'Navegar por páginas',
      getItemAriaLabel: function getItemAriaLabel(type, page, selected) {
        if (type === 'page') {
          return "".concat(selected ? '' : 'Ir para a ', "p\xE1gina ").concat(page);
        }

        if (type === 'first') {
          return 'Primeira página';
        }

        if (type === 'last') {
          return 'Última página';
        }

        if (type === 'next') {
          return 'Próxima página';
        }

        if (type === 'previous') {
          return 'Página anterior';
        }

        return undefined;
      }
    }
  }
};
exports.ptPT = ptPT;
var roRO = {
  props: {
    MuiBreadcrumbs: {
      expandText: 'Arată calea'
    },
    MuiTablePagination: {
      backIconButtonText: 'Pagina precedentă',
      labelRowsPerPage: 'Rânduri pe pagină:',
      labelDisplayedRows: function labelDisplayedRows(_ref24) {
        var from = _ref24.from,
            to = _ref24.to,
            count = _ref24.count;
        return "".concat(from, "-").concat(to, " din ").concat(count !== -1 ? count : "more than ".concat(to));
      },
      nextIconButtonText: 'Pagina următoare'
    },
    MuiRating: {
      getLabelText: function getLabelText(value) {
        return "".concat(value, " St").concat(value !== 1 ? 'ele' : 'ea');
      },
      emptyLabelText: 'Gol'
    },
    MuiAutocomplete: {
      clearText: 'Șterge',
      closeText: 'Închide',
      loadingText: 'Se încarcă…',
      noOptionsText: 'Nicio opțiune',
      openText: 'Deschide'
    },
    MuiAlert: {
      closeText: 'Închide'
    },
    MuiPagination: {
      'aria-label': 'Navigare prin paginare',
      getItemAriaLabel: function getItemAriaLabel(type, page, selected) {
        if (type === 'page') {
          return "".concat(selected ? '' : 'Mergi la ', "pagina ").concat(page);
        }

        if (type === 'first') {
          return 'Mergi la prima pagină';
        }

        if (type === 'last') {
          return 'Mergi la ultima pagină';
        }

        if (type === 'next') {
          return 'Mergi la pagina următoare';
        }

        if (type === 'previous') {
          return 'Mergi la pagina precedentă';
        }

        return undefined;
      }
    }
  }
};
exports.roRO = roRO;
var ruRU = {
  props: {
    // MuiBreadcrumbs: {
    //   expandText: 'Show path',
    // },
    MuiTablePagination: {
      backIconButtonText: 'Предыдущая страница',
      labelRowsPerPage: 'Строк на странице:',
      labelDisplayedRows: function labelDisplayedRows(_ref25) {
        var from = _ref25.from,
            to = _ref25.to,
            count = _ref25.count;
        return "".concat(from, "-").concat(to, " \u0438\u0437 ").concat(count !== -1 ? count : "\u0431\u043E\u043B\u0435\u0435 \u0447\u0435\u043C ".concat(to));
      },
      nextIconButtonText: 'Следующая страница'
    },
    MuiRating: {
      getLabelText: function getLabelText(value) {
        var pluralForm = 'Звёзд';
        var lastDigit = value % 10;

        if (lastDigit > 1 && lastDigit < 5) {
          pluralForm = 'Звезды';
        } else if (lastDigit === 1) {
          pluralForm = 'Звезда';
        }

        return "".concat(value, " ").concat(pluralForm);
      } // emptyLabelText: 'Empty',

    },
    MuiAutocomplete: {
      clearText: 'Очистить',
      closeText: 'Закрыть',
      loadingText: 'Загрузка…',
      noOptionsText: 'Нет доступных вариантов',
      openText: 'Открыть'
    },
    MuiAlert: {
      closeText: 'Закрыть'
    } // MuiPagination: {
    //   'aria-label': 'Pagination navigation',
    //   getItemAriaLabel: (type, page, selected) => {
    //     if (type === 'page') {
    //       return `${selected ? '' : 'Go to '}page ${page}`;
    //     }
    //     if (type === 'first') {
    //       return 'Go to first page';
    //     }
    //     if (type === 'last') {
    //       return 'Go to last page';
    //     }
    //     if (type === 'next') {
    //       return 'Go to next page';
    //     }
    //     if (type === 'previous') {
    //       return 'Go to previous page';
    //     }
    //     return undefined;
    //   },
    // },

  }
};
exports.ruRU = ruRU;
var skSK = {
  props: {
    // MuiBreadcrumbs: {
    //   expandText: 'Show path',
    // },
    MuiTablePagination: {
      backIconButtonText: 'Predchádzajúca stránka',
      labelRowsPerPage: 'Riadkov na stránke:',
      labelDisplayedRows: function labelDisplayedRows(_ref26) {
        var from = _ref26.from,
            to = _ref26.to,
            count = _ref26.count;
        return "".concat(from, "-").concat(to, " z ").concat(count !== -1 ? count : "more than ".concat(to));
      },
      nextIconButtonText: 'Ďalšia stránka'
    },
    MuiRating: {
      getLabelText: function getLabelText(value) {
        if (value === 1) {
          return "".concat(value, " hviezdi\u010Dka");
        }

        if (value >= 2 && value <= 4) {
          return "".concat(value, " hviezdi\u010Dky");
        }

        return "".concat(value, " hviezdi\u010Diek");
      } // emptyLabelText: 'Empty',

    },
    MuiAutocomplete: {
      clearText: 'Vymazať',
      closeText: 'Zavrieť',
      loadingText: 'Načítanie…',
      noOptionsText: 'Žiadne možnosti',
      openText: 'Otvoriť'
    },
    MuiAlert: {
      closeText: 'Zavrieť'
    } // MuiPagination: {
    //   'aria-label': 'Pagination navigation',
    //   getItemAriaLabel: (type, page, selected) => {
    //     if (type === 'page') {
    //       return `${selected ? '' : 'Go to '}page ${page}`;
    //     }
    //     if (type === 'first') {
    //       return 'Go to first page';
    //     }
    //     if (type === 'last') {
    //       return 'Go to last page';
    //     }
    //     if (type === 'next') {
    //       return 'Go to next page';
    //     }
    //     if (type === 'previous') {
    //       return 'Go to previous page';
    //     }
    //     return undefined;
    //   },
    // },

  }
};
exports.skSK = skSK;
var svSE = {
  props: {
    // MuiBreadcrumbs: {
    //   expandText: 'Show path',
    // },
    MuiTablePagination: {
      backIconButtonText: 'Föregående sida',
      labelRowsPerPage: 'Rader per sida:',
      labelDisplayedRows: function labelDisplayedRows(_ref27) {
        var from = _ref27.from,
            to = _ref27.to,
            count = _ref27.count;
        return "".concat(from, "-").concat(to, " av ").concat(count !== -1 ? count : "more than ".concat(to));
      },
      nextIconButtonText: 'Nästa sida'
    },
    MuiRating: {
      getLabelText: function getLabelText(value) {
        return "".concat(value, " ").concat(value !== 1 ? 'Stjärnor' : 'Stjärna');
      } // emptyLabelText: 'Empty',

    },
    MuiAutocomplete: {
      clearText: 'Rensa',
      closeText: 'Stäng',
      loadingText: 'Laddar…',
      noOptionsText: 'Inga alternativ',
      openText: 'Öppen'
    },
    MuiAlert: {
      closeText: 'Stäng'
    } // MuiPagination: {
    //   'aria-label': 'Pagination navigation',
    //   getItemAriaLabel: (type, page, selected) => {
    //     if (type === 'page') {
    //       return `${selected ? '' : 'Go to '}page ${page}`;
    //     }
    //     if (type === 'first') {
    //       return 'Go to first page';
    //     }
    //     if (type === 'last') {
    //       return 'Go to last page';
    //     }
    //     if (type === 'next') {
    //       return 'Go to next page';
    //     }
    //     if (type === 'previous') {
    //       return 'Go to previous page';
    //     }
    //     return undefined;
    //   },
    // },

  }
};
exports.svSE = svSE;
var trTR = {
  props: {
    MuiBreadcrumbs: {
      expandText: 'Yolu göster'
    },
    MuiTablePagination: {
      backIconButtonText: 'Önceki sayfa',
      labelRowsPerPage: 'Sayfa başına satır:',
      labelDisplayedRows: function labelDisplayedRows(_ref28) {
        var from = _ref28.from,
            to = _ref28.to,
            count = _ref28.count;
        return "".concat(from, "-").concat(to, " tanesinden ").concat(count !== -1 ? count : "more than ".concat(to));
      },
      nextIconButtonText: 'Sonraki sayfa'
    },
    MuiRating: {
      getLabelText: function getLabelText(value) {
        return "".concat(value, " Y\u0131ld\u0131z");
      },
      emptyLabelText: 'Boş'
    },
    MuiAutocomplete: {
      clearText: 'Temizle',
      closeText: 'Kapat',
      loadingText: 'Yükleniyor…',
      noOptionsText: 'Seçenek yok',
      openText: 'Aç'
    },
    MuiAlert: {
      closeText: 'Kapat'
    },
    MuiPagination: {
      'aria-label': 'Sayfa navigasyonu',
      getItemAriaLabel: function getItemAriaLabel(type, page, selected) {
        if (type === 'page') {
          return "".concat(page, ". ").concat(selected ? 'sayfa' : 'sayfaya git');
        }

        if (type === 'first') {
          return 'İlk sayfaya git';
        }

        if (type === 'last') {
          return 'Son sayfaya git';
        }

        if (type === 'next') {
          return 'Sonraki sayfaya git';
        }

        if (type === 'previous') {
          return 'Önceki sayfaya git';
        }

        return undefined;
      }
    }
  }
};
exports.trTR = trTR;
var ukUA = {
  props: {
    MuiBreadcrumbs: {
      expandText: 'Показати шлях сторінок'
    },
    MuiTablePagination: {
      backIconButtonText: 'Попередня сторінка',
      labelRowsPerPage: 'Рядків на сторінці:',
      labelDisplayedRows: function labelDisplayedRows(_ref29) {
        var from = _ref29.from,
            to = _ref29.to,
            count = _ref29.count;
        return "".concat(from, "-").concat(to, " \u0437 ").concat(count !== -1 ? count : "\u043F\u043E\u043D\u0430\u0434 ".concat(to));
      },
      nextIconButtonText: 'Наступна сторінка'
    },
    MuiRating: {
      getLabelText: function getLabelText(value) {
        var pluralForm = 'Зірок';
        var lastDigit = value % 10;

        if (lastDigit > 1 && lastDigit < 5) {
          pluralForm = 'Зірки';
        } else if (lastDigit === 1) {
          pluralForm = 'Зірка';
        }

        return "".concat(value, " ").concat(pluralForm);
      },
      emptyLabelText: 'Рейтинг відсутній'
    },
    MuiAutocomplete: {
      clearText: 'Очистити',
      closeText: 'Згорнути',
      loadingText: 'Завантаження…',
      noOptionsText: 'Немає варіантів',
      openText: 'Розгорнути'
    },
    MuiAlert: {
      closeText: 'Згорнути'
    },
    MuiPagination: {
      'aria-label': 'Навігація сторінками',
      getItemAriaLabel: function getItemAriaLabel(type, page, selected) {
        if (type === 'page') {
          return "".concat(selected ? '' : 'Перейти на ', "\u0441\u0442\u043E\u0440\u0456\u043D\u043A\u0443 ").concat(page);
        }

        if (type === 'first') {
          return 'Перейти на першу сторінку';
        }

        if (type === 'last') {
          return 'Перейти на останню сторінку';
        }

        if (type === 'next') {
          return 'Перейти на наступну сторінку';
        }

        if (type === 'previous') {
          return 'Перейти на попередню сторінку';
        }

        return undefined;
      }
    }
  }
};
exports.ukUA = ukUA;
var viVN = {
  props: {
    // MuiBreadcrumbs: {
    //   expandText: 'Show path',
    // },
    MuiTablePagination: {
      backIconButtonText: 'Trang trước',
      labelRowsPerPage: 'Số hàng mỗi trang:',
      labelDisplayedRows: function labelDisplayedRows(_ref30) {
        var from = _ref30.from,
            to = _ref30.to,
            count = _ref30.count;
        return "".concat(from, "-").concat(to, " trong ").concat(count !== -1 ? count : "nhi\u1EC1u h\u01A1n ".concat(to));
      },
      nextIconButtonText: 'Trang sau'
    },
    MuiRating: {
      getLabelText: function getLabelText(value) {
        return "".concat(value, " sao");
      },
      emptyLabelText: 'Trống'
    },
    MuiAutocomplete: {
      clearText: 'Xóa',
      closeText: 'Đóng',
      loadingText: 'Đang tải…',
      noOptionsText: 'Không có lựa chọn',
      openText: 'Mở'
    },
    MuiAlert: {
      closeText: 'Đóng'
    } // MuiPagination: {
    //   'aria-label': 'Pagination navigation',
    //   getItemAriaLabel: (type, page, selected) => {
    //     if (type === 'page') {
    //       return `${selected ? '' : 'Go to '}page ${page}`;
    //     }
    //     if (type === 'first') {
    //       return 'Go to first page';
    //     }
    //     if (type === 'last') {
    //       return 'Go to last page';
    //     }
    //     if (type === 'next') {
    //       return 'Go to next page';
    //     }
    //     if (type === 'previous') {
    //       return 'Go to previous page';
    //     }
    //     return undefined;
    //   },
    // },

  }
};
exports.viVN = viVN;
var zhCN = {
  props: {
    // MuiBreadcrumbs: {
    //   expandText: 'Show path',
    // },
    MuiTablePagination: {
      backIconButtonText: '上一页',
      labelRowsPerPage: '每页行数:',
      labelDisplayedRows: function labelDisplayedRows(_ref31) {
        var from = _ref31.from,
            to = _ref31.to,
            count = _ref31.count;
        return "".concat(from, "-").concat(to, " \u7684 ").concat(count !== -1 ? count : "\u8D85\u8FC7 ".concat(to));
      },
      nextIconButtonText: '下一页'
    },
    MuiRating: {
      getLabelText: function getLabelText(value) {
        return "".concat(value, " \u661F").concat(value !== 1 ? '星' : '');
      } // emptyLabelText: 'Empty',

    },
    MuiAutocomplete: {
      clearText: '明确',
      closeText: '关',
      loadingText: '载入中…',
      noOptionsText: '没有选择',
      openText: '打开'
    },
    MuiAlert: {
      closeText: '关'
    } // MuiPagination: {
    //   'aria-label': 'Pagination navigation',
    //   getItemAriaLabel: (type, page, selected) => {
    //     if (type === 'page') {
    //       return `${selected ? '' : 'Go to '}page ${page}`;
    //     }
    //     if (type === 'first') {
    //       return 'Go to first page';
    //     }
    //     if (type === 'last') {
    //       return 'Go to last page';
    //     }
    //     if (type === 'next') {
    //       return 'Go to next page';
    //     }
    //     if (type === 'previous') {
    //       return 'Go to previous page';
    //     }
    //     return undefined;
    //   },
    // },

  }
};
exports.zhCN = zhCN;