import { BaseBackend } from '@sentry/core';
import { Event, EventHint, Options, Severity, Transport } from '@sentry/types';
/**
 * Configuration options for the Sentry Browser SDK.
 * @see BrowserClient for more information.
 */
export interface BrowserOptions extends Options {
    /**
     * A pattern for error URLs which should exclusively be sent to Sentry.
     * This is the opposite of {@link Options.denyUrls}.
     * By default, all errors will be sent.
     */
    allowUrls?: Array<string | RegExp>;
    /**
     * A pattern for error URLs which should not be sent to Sentry.
     * To allow certain errors instead, use {@link Options.allowUrls}.
     * By default, all errors will be sent.
     */
    denyUrls?: Array<string | RegExp>;
    /** @deprecated use {@link Options.allowUrls} instead. */
    whitelistUrls?: Array<string | RegExp>;
    /** @deprecated use {@link Options.denyUrls} instead. */
    blacklistUrls?: Array<string | RegExp>;
    /**
     * A flag enabling Sessions Tracking feature.
     * By default Sessions Tracking is disabled.
     */
    autoSessionTracking?: boolean;
}
/**
 * The Sentry Browser SDK Backend.
 * @hidden
 */
export declare class BrowserBackend extends BaseBackend<BrowserOptions> {
    /**
     * @inheritDoc
     */
    eventFromException(exception: unknown, hint?: EventHint): PromiseLike<Event>;
    /**
     * @inheritDoc
     */
    eventFromMessage(message: string, level?: Severity, hint?: EventHint): PromiseLike<Event>;
    /**
     * @inheritDoc
     */
    protected _setupTransport(): Transport;
}
//# sourceMappingURL=backend.d.ts.map