"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.applyCaseMiddleware = exports.createCamelResponseTransformer = exports.createSnakeRequestTransformer = exports.createSnakeParamsInterceptor = void 0;
var tslib_1 = require("tslib");
var transformers_1 = require("./transformers");
var util_1 = require("./util");
var createSnakeParamsInterceptor = function (options) {
    var snake = transformers_1.createObjectTransformers(options === null || options === void 0 ? void 0 : options.caseFunctions).snake;
    return function (config) {
        if (config.params) {
            config.params = snake(config.params, options);
        }
        return config;
    };
};
exports.createSnakeParamsInterceptor = createSnakeParamsInterceptor;
var createSnakeRequestTransformer = function (options) {
    var _a = transformers_1.createObjectTransformers(options === null || options === void 0 ? void 0 : options.caseFunctions), snake = _a.snake, header = _a.header;
    return function (data, headers) {
        var e_1, _a, _b;
        if (!(options === null || options === void 0 ? void 0 : options.ignoreHeaders) && util_1.isPlainObject(headers)) {
            try {
                for (var _c = tslib_1.__values(Object.entries(headers)), _d = _c.next(); !_d.done; _d = _c.next()) {
                    var _e = tslib_1.__read(_d.value, 2), key = _e[0], value = _e[1];
                    header(value, tslib_1.__assign({ overwrite: true }, options));
                    if (!['common', 'delete', 'get', 'head', 'post', 'put', 'patch'].includes(key)) {
                        delete headers[key];
                        headers[Object.keys(header((_b = {}, _b[key] = null, _b), options))[0]] = value;
                    }
                }
            }
            catch (e_1_1) { e_1 = { error: e_1_1 }; }
            finally {
                try {
                    if (_d && !_d.done && (_a = _c.return)) _a.call(_c);
                }
                finally { if (e_1) throw e_1.error; }
            }
        }
        return snake(data, options);
    };
};
exports.createSnakeRequestTransformer = createSnakeRequestTransformer;
var createCamelResponseTransformer = function (options) {
    var camel = transformers_1.createObjectTransformers(options === null || options === void 0 ? void 0 : options.caseFunctions).camel;
    return function (data, headers) {
        if (!(options === null || options === void 0 ? void 0 : options.ignoreHeaders)) {
            camel(headers, tslib_1.__assign({ overwrite: true }, options));
        }
        return camel(data, options);
    };
};
exports.createCamelResponseTransformer = createCamelResponseTransformer;
var applyCaseMiddleware = function (axios, options) {
    var _a, _b, _c;
    axios.defaults.transformRequest = tslib_1.__spreadArray([
        ((_a = options === null || options === void 0 ? void 0 : options.caseMiddleware) === null || _a === void 0 ? void 0 : _a.requestTransformer) ||
            exports.createSnakeRequestTransformer(options)
    ], tslib_1.__read((Array.isArray(axios.defaults.transformRequest)
        ? axios.defaults.transformRequest
        : axios.defaults.transformRequest !== undefined
            ? [axios.defaults.transformRequest]
            : [])));
    axios.defaults.transformResponse = tslib_1.__spreadArray(tslib_1.__spreadArray([], tslib_1.__read((Array.isArray(axios.defaults.transformResponse)
        ? axios.defaults.transformResponse
        : axios.defaults.transformResponse !== undefined
            ? [axios.defaults.transformResponse]
            : []))), [
        ((_b = options === null || options === void 0 ? void 0 : options.caseMiddleware) === null || _b === void 0 ? void 0 : _b.responseTransformer) ||
            exports.createCamelResponseTransformer(options),
    ]);
    axios.interceptors.request.use(((_c = options === null || options === void 0 ? void 0 : options.caseMiddleware) === null || _c === void 0 ? void 0 : _c.requestInterceptor) ||
        exports.createSnakeParamsInterceptor(options));
    return axios;
};
exports.applyCaseMiddleware = applyCaseMiddleware;
