"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.preserveSpecificKeys = exports.applyCaseOptions = void 0;
var tslib_1 = require("tslib");
var applyCaseOptions = function (fn, defaultOptions) {
    return function (input, options) {
        return fn(input, tslib_1.__assign(tslib_1.__assign({}, defaultOptions), options));
    };
};
exports.applyCaseOptions = applyCaseOptions;
var preserveSpecificKeys = function (fn, keys) {
    var condition = typeof keys === 'function'
        ? keys
        : function (input) { return keys.includes(input); };
    return function (input, options) {
        return condition(input, options) ? input : fn(input, options);
    };
};
exports.preserveSpecificKeys = preserveSpecificKeys;
