var __assign = (this && this.__assign) || function () {
    __assign = Object.assign || function(t) {
        for (var s, i = 1, n = arguments.length; i < n; i++) {
            s = arguments[i];
            for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p))
                t[p] = s[p];
        }
        return t;
    };
    return __assign.apply(this, arguments);
};
import { Tooltip } from '@patternfly/react-core';
import { QuestionIcon, SecurityIcon } from '@patternfly/react-icons';
import React from 'react';
import { impactList } from './consts';
var Shield = function (_a) {
    var _b;
    var _c = _a.impact, impact = _c === void 0 ? 'N/A' : _c, _d = _a.hasLabel, hasLabel = _d === void 0 ? false : _d, _e = _a.size, size = _e === void 0 ? 'sm' : _e, _f = _a.hasTooltip, hasTooltip = _f === void 0 ? true : _f;
    var attributes = (_b = impactList === null || impactList === void 0 ? void 0 : impactList[impact]) !== null && _b !== void 0 ? _b : impactList.Unknown;
    var badgeProps = {
        'aria-hidden': 'false',
        'aria-label': attributes.title,
        color: attributes.color,
        size: size,
    };
    var badge = attributes.title === 'Unknown' ? React.createElement(QuestionIcon, __assign({}, badgeProps)) : React.createElement(SecurityIcon, __assign({}, badgeProps));
    var body = (React.createElement("span", null,
        badge,
        " ",
        hasLabel && attributes.title));
    return (React.createElement("span", null, hasTooltip ? (React.createElement(Tooltip, { content: React.createElement("div", null, attributes.message), position: 'bottom' }, body)) : (body)));
};
export default Shield;
//# sourceMappingURL=Shield.js.map