var __assign = (this && this.__assign) || function () {
    __assign = Object.assign || function(t) {
        for (var s, i = 1, n = arguments.length; i < n; i++) {
            s = arguments[i];
            for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p))
                t[p] = s[p];
        }
        return t;
    };
    return __assign.apply(this, arguments);
};
var __rest = (this && this.__rest) || function (s, e) {
    var t = {};
    for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p) && e.indexOf(p) < 0)
        t[p] = s[p];
    if (s != null && typeof Object.getOwnPropertySymbols === "function")
        for (var i = 0, p = Object.getOwnPropertySymbols(s); i < p.length; i++) {
            if (e.indexOf(p[i]) < 0 && Object.prototype.propertyIsEnumerable.call(s, p[i]))
                t[p[i]] = s[p[i]];
        }
    return t;
};
var __spreadArray = (this && this.__spreadArray) || function (to, from, pack) {
    if (pack || arguments.length === 2) for (var i = 0, l = from.length, ar; i < l; i++) {
        if (ar || !(i in from)) {
            if (!ar) ar = Array.prototype.slice.call(from, 0, i);
            ar[i] = from[i];
        }
    }
    return to.concat(ar || Array.prototype.slice.call(from));
};
import React from 'react';
import classNames from 'classnames';
import { connect } from 'react-redux';
import { DarkContext } from '../Dark';
import './main.css';
var toKebab = function (text) { return text.replace(/([a-z0-9])([A-Z])/g, '$1-$2').toLowerCase(); };
export var InternalMain = function (_a) {
    var path = _a.path, _b = _a.params, params = _b === void 0 ? {} : _b, children = _a.children, className = _a.className, props = __rest(_a, ["path", "params", "children", "className"]);
    var calculateLocation = function () {
        var _a, _b, _c;
        if ((_c = (_b = (_a = window === null || window === void 0 ? void 0 : window.insights) === null || _a === void 0 ? void 0 : _a.chrome) === null || _b === void 0 ? void 0 : _b.$internal) === null || _c === void 0 ? void 0 : _c.store) {
            var chromeState = window.insights.chrome.$internal.store.getState();
            if (path && chromeState) {
                return path.split('/').reduce(function (acc, curr) {
                    var _a;
                    if (curr.indexOf(':') === 0) {
                        acc.dynamic = __assign(__assign({}, acc.dynamic), (_a = {}, _a["data-".concat(toKebab(curr.substr(1)))] = params[curr.substr(1)], _a));
                    }
                    else {
                        acc.staticPart = __spreadArray(__spreadArray([], acc.staticPart, true), (curr !== '' ? [curr] : []), true);
                    }
                    return acc;
                }, { staticPart: [chromeState.chrome.appId], dynamic: {} });
            }
        }
        return {
            staticPart: [],
            dynamic: undefined,
        };
    };
    var _c = calculateLocation(), dynamic = _c.dynamic, staticPart = _c.staticPart;
    return (React.createElement(DarkContext.Consumer, null, function (theme) {
        var _a;
        if (theme === void 0) { theme = 'light'; }
        var themeClasses = classNames((_a = {}, _a["pf-m-".concat(theme)] = theme === 'dark', _a));
        return {
            dark: (React.createElement("section", __assign({}, props, dynamic, { "page-type": staticPart.join('-'), className: "".concat(classNames(className, 'pf-l-page__main-section pf-c-page__main-section'), " ").concat(themeClasses) }), React.Children.map(children, function (child) {
                return React.cloneElement(child, {
                    className: 'pf-m-dark',
                });
            }))),
            light: (React.createElement("section", __assign({}, props, dynamic, { "page-type": staticPart.join('-'), className: "".concat(classNames(className, 'pf-l-page__main-section pf-c-page__main-section')) }), children)),
        }[theme];
    }));
};
var mapStateToProps = function (_a) {
    var routerData = _a.routerData;
    return ({
        params: routerData && routerData.params,
        path: routerData && routerData.path,
    });
};
var Main = connect(mapStateToProps, function () { return ({}); })(InternalMain);
export default Main;
//# sourceMappingURL=Main.js.map