var __assign = (this && this.__assign) || function () {
    __assign = Object.assign || function(t) {
        for (var s, i = 1, n = arguments.length; i < n; i++) {
            s = arguments[i];
            for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p))
                t[p] = s[p];
        }
        return t;
    };
    return __assign.apply(this, arguments);
};
import React from 'react';
import PropTypes from 'prop-types';
import { Badge, Chip, ChipGroup, Button } from '@patternfly/react-core';
import classNames from 'classnames';
import './filter-chips.css';
var FilterChips = function (_a) {
    var className = _a.className, filters = _a.filters, onDelete = _a.onDelete, deleteTitle = _a.deleteTitle, showDeleteButton = _a.showDeleteButton, onDeleteGroup = _a.onDeleteGroup;
    var groups = filters.filter(function (group) { return Object.prototype.hasOwnProperty.call(group, 'category'); });
    var groupedFilters = groups.map(function (group, groupKey) { return (React.createElement(ChipGroup, __assign({ key: "group_".concat(group.category), categoryName: String(group.category) || ' ' }, (onDeleteGroup && {
        isClosable: true,
        onClick: function (event) {
            event.stopPropagation();
            onDeleteGroup(event, [group], groups.filter(function (_item, key) { return key !== groupKey; }));
        },
    })), group.chips.map(function (chip) { return (React.createElement(Chip, { key: chip.name, onClick: function (event) {
            event.stopPropagation();
            onDelete(event, [__assign(__assign({}, group), { chips: [chip] })]);
        } },
        chip.name,
        chip.count && (React.createElement(Badge, { key: "chip_badge_".concat(chip.id), isRead: chip.isRead }, chip.count)))); }))); });
    var plainFilters = filters.filter(function (group) { return !Object.prototype.hasOwnProperty.call(group, 'category'); });
    return (React.createElement("span", { className: classNames(className, 'ins-c-chip-filters') },
        groupedFilters,
        plainFilters &&
            plainFilters.map(function (chip) { return (React.createElement(ChipGroup, { key: "group_plain_chip_".concat(chip.name) },
                React.createElement(Chip, { onClick: function (event) {
                        event.stopPropagation();
                        onDelete(event, [chip]);
                    } },
                    chip.name,
                    chip.count && (React.createElement(Badge, { key: "chip_badge_".concat(chip.id), isRead: chip.isRead }, chip.count))))); }),
        (showDeleteButton === true || (showDeleteButton === undefined && filters.length > 0)) && (React.createElement(Button, { variant: "link", ouiaId: "ClearFilters", onClick: function (event) { return onDelete(event, filters, true); } }, deleteTitle))));
};
FilterChips.propTypes = {
    className: PropTypes.string,
    filters: PropTypes.arrayOf(PropTypes.oneOfType([
        PropTypes.shape({
            category: PropTypes.string.isRequired,
            chips: PropTypes.arrayOf(PropTypes.shape({
                name: PropTypes.string.isRequired,
                isRead: PropTypes.bool,
                count: PropTypes.number,
            })).isRequired,
        }),
        PropTypes.shape({
            name: PropTypes.string.isRequired,
            isRead: PropTypes.bool,
            count: PropTypes.number,
        }),
    ])),
    onDelete: PropTypes.func,
    onDeleteGroup: PropTypes.func,
    deleteTitle: PropTypes.node,
    showDeleteButton: PropTypes.bool,
};
FilterChips.defaultProps = {
    filters: [],
    onDelete: function () { return undefined; },
    deleteTitle: 'Clear filters',
};
export default FilterChips;
//# sourceMappingURL=FilterChips.js.map