var __assign = (this && this.__assign) || function () {
    __assign = Object.assign || function(t) {
        for (var s, i = 1, n = arguments.length; i < n; i++) {
            s = arguments[i];
            for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p))
                t[p] = s[p];
        }
        return t;
    };
    return __assign.apply(this, arguments);
};
var __rest = (this && this.__rest) || function (s, e) {
    var t = {};
    for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p) && e.indexOf(p) < 0)
        t[p] = s[p];
    if (s != null && typeof Object.getOwnPropertySymbols === "function")
        for (var i = 0, p = Object.getOwnPropertySymbols(s); i < p.length; i++) {
            if (e.indexOf(p[i]) < 0 && Object.prototype.propertyIsEnumerable.call(s, p[i]))
                t[p[i]] = s[p[i]];
        }
    return t;
};
import React from 'react';
import { ExclamationCircleIcon, ExclamationTriangleIcon } from '@patternfly/react-icons';
import { Tooltip } from '@patternfly/react-core';
import classnames from 'classnames';
import './CullingInformation.css';
import { calculateTooltip } from './utils';
var CullingInformation = function (_a) {
    var _b = _a.culled, culled = _b === void 0 ? new Date(0) : _b, className = _a.className, _c = _a.staleWarning, staleWarning = _c === void 0 ? new Date(0) : _c, _d = _a.stale, stale = _d === void 0 ? new Date(0) : _d, _e = _a.currDate, currDate = _e === void 0 ? new Date(0) : _e, children = _a.children, render = _a.render, props = __rest(_a, ["culled", "className", "staleWarning", "stale", "currDate", "children", "render"]);
    if (new Date(currDate).valueOf() - new Date(stale).valueOf() < 0) {
        return render
            ? render({
                msg: '',
            })
            : children || null;
    }
    var _f = calculateTooltip(culled, staleWarning, currDate), isWarn = _f.isWarn, isError = _f.isError, msg = _f.msg;
    if (render) {
        return (React.createElement("span", { className: classnames({
                'ins-c-inventory__culling-warning': isWarn,
                'ins-c-inventory__culling-danger': isError,
            }, className) },
            isWarn && React.createElement(ExclamationTriangleIcon, null),
            isError && React.createElement(ExclamationCircleIcon, null),
            render({ msg: msg })));
    }
    return (React.createElement(React.Fragment, null,
        React.createElement(Tooltip, __assign({}, props, { content: msg, position: "bottom" }),
            React.createElement("span", { className: classnames({
                    'ins-c-inventory__culling-warning': isWarn,
                    'ins-c-inventory__culling-danger': isError,
                }, className) },
                isError && React.createElement(ExclamationCircleIcon, null),
                isWarn && React.createElement(ExclamationTriangleIcon, null),
                children))));
};
export default CullingInformation;
//# sourceMappingURL=CullingInformation.js.map