"use strict";
var __assign = (this && this.__assign) || function () {
    __assign = Object.assign || function(t) {
        for (var s, i = 1, n = arguments.length; i < n; i++) {
            s = arguments[i];
            for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p))
                t[p] = s[p];
        }
        return t;
    };
    return __assign.apply(this, arguments);
};
var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    Object.defineProperty(o, k2, { enumerable: true, get: function() { return m[k]; } });
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __setModuleDefault = (this && this.__setModuleDefault) || (Object.create ? (function(o, v) {
    Object.defineProperty(o, "default", { enumerable: true, value: v });
}) : function(o, v) {
    o["default"] = v;
});
var __importStar = (this && this.__importStar) || function (mod) {
    if (mod && mod.__esModule) return mod;
    var result = {};
    if (mod != null) for (var k in mod) if (k !== "default" && Object.prototype.hasOwnProperty.call(mod, k)) __createBinding(result, mod, k);
    __setModuleDefault(result, mod);
    return result;
};
var __rest = (this && this.__rest) || function (s, e) {
    var t = {};
    for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p) && e.indexOf(p) < 0)
        t[p] = s[p];
    if (s != null && typeof Object.getOwnPropertySymbols === "function")
        for (var i = 0, p = Object.getOwnPropertySymbols(s); i < p.length; i++) {
            if (e.indexOf(p[i]) < 0 && Object.prototype.propertyIsEnumerable.call(s, p[i]))
                t[p[i]] = s[p[i]];
        }
    return t;
};
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
var react_1 = __importStar(require("react"));
var react_core_1 = require("@patternfly/react-core");
var react_core_2 = require("@patternfly/react-core/");
var classnames_1 = __importDefault(require("classnames"));
var prop_types_1 = __importDefault(require("prop-types"));
require("./TableToolbar.css");
function generateCount(results) {
    if (results > 1 || results < 1) {
        return "".concat(results, " Results");
    }
    else {
        return "".concat(results, " Result");
    }
}
var TableToolbar = function (_a) {
    var _b;
    var isFooter = _a.isFooter, results = _a.results, className = _a.className, selected = _a.selected, children = _a.children, ouiaId = _a.ouiaId, _c = _a.ouiaSafe, ouiaSafe = _c === void 0 ? true : _c, props = __rest(_a, ["isFooter", "results", "className", "selected", "children", "ouiaId", "ouiaSafe"]);
    var tableToolbarClasses = (0, classnames_1.default)('ins-c-table__toolbar', (_b = {}, _b["ins-m-footer"] = isFooter, _b), className);
    var ouiaComponentType = 'RHI/TableToolbar';
    var ouiaFinalId = (0, react_core_2.useOUIAId)(ouiaComponentType, ouiaId, ouiaSafe);
    return (react_1.default.createElement(react_1.Fragment, null,
        react_1.default.createElement(react_core_1.Toolbar, __assign({ className: tableToolbarClasses, "data-ouia-component-type": ouiaComponentType, "data-ouia-component-id": ouiaFinalId, "data-ouia-safe": ouiaSafe }, props), children),
        (results >= 0 || selected >= 0) && (react_1.default.createElement("div", { className: "ins-c-table__toolbar-results" },
            results >= 0 && react_1.default.createElement("span", { className: "ins-c-table__toolbar-results-count" },
                " ",
                generateCount(results),
                " "),
            selected >= 0 && react_1.default.createElement("span", { className: "ins-c-table__toolbar-results-selected" },
                " ",
                selected,
                " Selected ")))));
};
exports.default = TableToolbar;
TableToolbar.propTypes = {
    isFooter: prop_types_1.default.bool,
    results: prop_types_1.default.number,
    children: prop_types_1.default.any,
    className: prop_types_1.default.string,
    selected: prop_types_1.default.number,
    ouiaId: prop_types_1.default.string,
    ouiaSafe: prop_types_1.default.bool,
};
TableToolbar.defaultProps = {
    isFooter: false,
};
//# sourceMappingURL=TableToolbar.js.map