"use strict";
var __assign = (this && this.__assign) || function () {
    __assign = Object.assign || function(t) {
        for (var s, i = 1, n = arguments.length; i < n; i++) {
            s = arguments[i];
            for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p))
                t[p] = s[p];
        }
        return t;
    };
    return __assign.apply(this, arguments);
};
var __rest = (this && this.__rest) || function (s, e) {
    var t = {};
    for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p) && e.indexOf(p) < 0)
        t[p] = s[p];
    if (s != null && typeof Object.getOwnPropertySymbols === "function")
        for (var i = 0, p = Object.getOwnPropertySymbols(s); i < p.length; i++) {
            if (e.indexOf(p[i]) < 0 && Object.prototype.propertyIsEnumerable.call(s, p[i]))
                t[p[i]] = s[p[i]];
        }
    return t;
};
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
require("./labels.css");
var react_icons_1 = require("@patternfly/react-icons");
var react_icons_2 = require("@patternfly/react-icons");
var CriticalIcon_1 = __importDefault(require("./CriticalIcon"));
var react_icons_3 = require("@patternfly/react-icons");
var react_core_1 = require("@patternfly/react-core");
var react_1 = __importDefault(require("react"));
var classnames_1 = __importDefault(require("classnames"));
var VALUE_TO_STATE = {
    1: { icon: react_1.default.createElement(react_icons_1.AngleDoubleDownIcon, null), text: 'Low' },
    2: { icon: react_1.default.createElement(react_icons_3.EqualsIcon, null), text: 'Moderate' },
    3: { icon: react_1.default.createElement(react_icons_2.AngleDoubleUpIcon, null), text: 'Important' },
    4: { icon: react_1.default.createElement(CriticalIcon_1.default, null), text: 'Critical' },
};
var InsightsLabel = function (_a) {
    var _b = _a.value, value = _b === void 0 ? 1 : _b, text = _a.text, hideIcon = _a.hideIcon, className = _a.className, rest = _a.rest, props = __rest(_a, ["value", "text", "hideIcon", "className", "rest"]);
    return (react_1.default.createElement(react_core_1.Label, __assign({}, rest, props, { className: (0, classnames_1.default)(className, "ins-c-label-".concat(value)), icon: !hideIcon && VALUE_TO_STATE[value].icon }), text || VALUE_TO_STATE[value].text));
};
exports.default = InsightsLabel;
//# sourceMappingURL=InsightsLabel.js.map