"use strict";
var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (Object.prototype.hasOwnProperty.call(b, p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        if (typeof b !== "function" && b !== null)
            throw new TypeError("Class extends value " + String(b) + " is not a constructor or null");
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
var __assign = (this && this.__assign) || function () {
    __assign = Object.assign || function(t) {
        for (var s, i = 1, n = arguments.length; i < n; i++) {
            s = arguments[i];
            for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p))
                t[p] = s[p];
        }
        return t;
    };
    return __assign.apply(this, arguments);
};
var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    Object.defineProperty(o, k2, { enumerable: true, get: function() { return m[k]; } });
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __setModuleDefault = (this && this.__setModuleDefault) || (Object.create ? (function(o, v) {
    Object.defineProperty(o, "default", { enumerable: true, value: v });
}) : function(o, v) {
    o["default"] = v;
});
var __importStar = (this && this.__importStar) || function (mod) {
    if (mod && mod.__esModule) return mod;
    var result = {};
    if (mod != null) for (var k in mod) if (k !== "default" && Object.prototype.hasOwnProperty.call(mod, k)) __createBinding(result, mod, k);
    __setModuleDefault(result, mod);
    return result;
};
var __rest = (this && this.__rest) || function (s, e) {
    var t = {};
    for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p) && e.indexOf(p) < 0)
        t[p] = s[p];
    if (s != null && typeof Object.getOwnPropertySymbols === "function")
        for (var i = 0, p = Object.getOwnPropertySymbols(s); i < p.length; i++) {
            if (e.indexOf(p[i]) < 0 && Object.prototype.propertyIsEnumerable.call(s, p[i]))
                t[p[i]] = s[p[i]];
        }
    return t;
};
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.ScalprumComponent = void 0;
var react_1 = __importStar(require("react"));
var core_1 = require("@scalprum/core");
var isEqual_1 = __importDefault(require("lodash/isEqual"));
var async_loader_1 = require("./async-loader");
var DefaultErrorComponent = function () { return react_1.default.createElement("span", null, "Error while loading component!"); };
var LoadModule = function (_a) {
    var _b = _a.fallback, fallback = _b === void 0 ? 'loading' : _b, appName = _a.appName, scope = _a.scope, module = _a.module, ErrorComponent = _a.ErrorComponent, processor = _a.processor, innerRef = _a.innerRef, _c = _a.skipCache, skipCache = _c === void 0 ? false : _c, props = __rest(_a, ["fallback", "appName", "scope", "module", "ErrorComponent", "processor", "innerRef", "skipCache"]);
    var _d = (0, core_1.getAppData)(appName), scriptLocation = _d.scriptLocation, manifestLocation = _d.manifestLocation;
    var _e = (0, react_1.useState)(undefined), Component = _e[0], setComponent = _e[1];
    var cachedModule = (0, core_1.getCachedModule)(scope, module, skipCache);
    var isMounted = (0, react_1.useRef)(true);
    (0, react_1.useEffect)(function () {
        if (!cachedModule) {
            if (scriptLocation) {
                (0, core_1.injectScript)(appName, scriptLocation)
                    .then(function () {
                    isMounted.current && setComponent(function () { return react_1.default.lazy((0, async_loader_1.loadComponent)(scope, module, ErrorComponent)); });
                })
                    .catch(function () {
                    isMounted.current && setComponent(function () { return ErrorComponent; });
                });
            }
            else if (manifestLocation) {
                (0, core_1.processManifest)(manifestLocation, appName, scope, processor)
                    .then(function () {
                    isMounted.current && setComponent(function () { return react_1.default.lazy((0, async_loader_1.loadComponent)(scope, module, ErrorComponent)); });
                })
                    .catch(function () {
                    isMounted.current && setComponent(function () { return ErrorComponent; });
                });
            }
        }
        else {
            try {
                isMounted.current && setComponent(function () { return cachedModule.default; });
            }
            catch (_a) {
                isMounted.current && setComponent(function () { return ErrorComponent; });
            }
        }
        return function () {
            isMounted.current = false;
        };
    }, [appName, scope, cachedModule, skipCache]);
    return react_1.default.createElement(react_1.Suspense, { fallback: fallback }, Component ? react_1.default.createElement(Component, __assign({ ref: innerRef }, props)) : fallback);
};
var BaseScalprumComponent = (function (_super) {
    __extends(BaseScalprumComponent, _super);
    function BaseScalprumComponent(props) {
        var _this = _super.call(this, props) || this;
        _this.state = { hasError: false };
        _this.selfRepairAttempt = false;
        return _this;
    }
    BaseScalprumComponent.getDerivedStateFromError = function () {
        return { hasError: true };
    };
    BaseScalprumComponent.prototype.shouldComponentUpdate = function (nextProps, nextState) {
        if (this.state.hasError !== nextState.hasError) {
            return true;
        }
        return !(0, isEqual_1.default)(nextProps, this.props) || !(0, isEqual_1.default)(nextState, this.state);
    };
    BaseScalprumComponent.prototype.componentDidCatch = function (error, errorInfo) {
        if (this.selfRepairAttempt === true) {
            console.error('Scalprum encountered an error!', error.message);
            this.setState({ error: error, errorInfo: errorInfo });
        }
        else {
            console.warn('Scalprum failed to render component. Attempting to skip module cache.');
            this.setState({ repairAttempt: true });
        }
    };
    BaseScalprumComponent.prototype.render = function () {
        var _a = this.props, _b = _a.ErrorComponent, ErrorComponent = _b === void 0 ? react_1.default.createElement(DefaultErrorComponent, null) : _b, props = __rest(_a, ["ErrorComponent"]);
        if (this.state.repairAttempt && !this.selfRepairAttempt) {
            this.selfRepairAttempt = true;
            return react_1.default.createElement(LoadModule, __assign({}, props, { skipCache: true, ErrorComponent: function () { return react_1.default.createElement(react_1.Fragment, null, ErrorComponent); } }));
        }
        if (this.state.hasError && this.selfRepairAttempt) {
            return react_1.default.cloneElement(ErrorComponent, __assign({}, this.state));
        }
        return react_1.default.createElement(LoadModule, __assign({}, props, { ErrorComponent: function () { return react_1.default.createElement(react_1.Fragment, null, ErrorComponent); } }));
    };
    BaseScalprumComponent.defaultProps = {
        ErrorComponent: react_1.default.createElement(DefaultErrorComponent, null),
    };
    return BaseScalprumComponent;
}(react_1.default.Component));
exports.ScalprumComponent = react_1.default.forwardRef(function (props, ref) { return (react_1.default.createElement(BaseScalprumComponent, __assign({}, props, { innerRef: ref }))); });
//# sourceMappingURL=scalprum-component.js.map