import * as React from 'react';
import { ButtonProps, PopoverPosition } from '@patternfly/react-core';
export interface CodeEditorControlProps extends Omit<ButtonProps, 'onClick'> {
    /** icon rendered inside the code editor control */
    icon: React.ReactNode;
    /** additional classes added to the Code editor control */
    className?: string;
    /** accessible label for the code editor control */
    'aria-label'?: string;
    /** Text to display in the tooltip*/
    toolTipText: React.ReactNode;
    /** Copy button popover position. */
    position?: PopoverPosition | 'auto' | 'top' | 'bottom' | 'left' | 'right';
    /** Maximum width of the tooltip (default 150px). */
    maxWidth?: string;
    /** Delay in ms before the tooltip disappears. */
    exitDelay?: number;
    /** Delay in ms before the tooltip appears. */
    entryDelay?: number;
    /** Event handler for the click of the button */
    onClick: (code: string, event?: any) => void;
    /** Flag indicating that the button is visible above the code editor */
    isVisible?: boolean;
}
export declare const CodeEditorControl: React.FunctionComponent<CodeEditorControlProps>;
//# sourceMappingURL=CodeEditorControl.d.ts.map