import { AxiosPromise } from 'axios';
import { ResourceUIState } from '../../common';
declare type ApiCall<P, T> = (params: P) => AxiosPromise<T>;
declare type State<T> = {
    data?: T;
    uiState: ResourceUIState;
};
declare type Config = {
    manual?: boolean;
    initialUIState?: ResourceUIState;
};
declare const useApi: <Data, P>(apiCall: ApiCall<P, Data>, params?: P | undefined, config?: Config | undefined) => [State<Data>, (params?: P | undefined) => void];
export default useApi;
