import React from 'react';
import { ISortBy, IRow } from '@patternfly/react-table';
export declare type HumanizedSortable = {
    title: string | React.ReactNode;
    sortableValue: number | string;
};
declare type getCellType = (row: IRow, index: number | undefined) => string | HumanizedSortable;
/**
 * Generates rows array for item which spans across all table columns.
 * Used to put EmptyState etc. components into the table body.
 */
export declare const getColSpanRow: (content: React.ReactNode, columnCount: number) => IRow[];
export declare const rowSorter: (sortBy: ISortBy, getCell: getCellType) => (a: IRow, b: IRow) => number;
/** Converts string into a sentence by capitalizing first letter and appending with . */
export declare const toSentence: (s: string) => string;
export declare const getDateTimeCell: (time?: string | undefined) => HumanizedSortable;
export {};
