import React from 'react';
import { Button } from '@patternfly/react-core';
import { ToolbarButton } from './Toolbar';
import { Cluster, Event } from '../../api';
import { EventListFetchProps, EventsEntityKind } from '../../types';
import './EventsModal.css';
declare type EventsModalButtonProps = React.ComponentProps<typeof Button> & {
    ButtonComponent?: typeof Button | typeof ToolbarButton;
    onFetchEvents: EventListFetchProps['onFetchEvents'];
    onClick?: () => void;
    hostId?: Event['hostId'];
    cluster: Cluster;
    entityKind: EventsEntityKind;
    title: string;
    fallbackEventsURL?: string;
};
export declare const EventsModalButton: React.FC<EventsModalButtonProps>;
declare type EventsModalProps = {
    onFetchEvents: EventListFetchProps['onFetchEvents'];
    hostId: Event['hostId'];
    cluster: Cluster;
    entityKind: EventsEntityKind;
    onClose: () => void;
    isOpen: boolean;
    title: string;
    fallbackEventsURL?: string;
};
export declare const EventsModal: React.FC<EventsModalProps>;
export {};
