import React, { ReactChild } from 'react';
import { TextProps } from '@patternfly/react-core';
import { WithTestID } from '../../types';
import './DetailList.css';
export declare type DetailListProps = {
    children: ReactChild | (ReactChild | undefined)[];
    title?: string;
    titleComponent?: TextProps['component'];
};
export declare type DetailItemProps = {
    title: string;
    value?: {
        title: string;
        value?: string;
    }[] | React.ReactNode;
    idPrefix?: string;
    isHidden?: boolean;
    classNameValue?: string;
};
export declare const DetailList: React.FC<DetailListProps>;
export declare const DetailItem: React.FC<DetailItemProps & WithTestID>;
