import * as React from 'react';
import { Address4, Address6 } from 'ip-address';
import { Cluster, Host, Interface } from '../../api';
import { ActionsResolver, TableRow } from './AITable';
import { HostsTableActions } from './types';
export declare const getSelectedNic: (nics: Interface[], currentSubnet: Address4 | Address6) => Interface | undefined;
export declare const hostnameColumn: (onEditHostname?: HostsTableActions['onEditHost'], hosts?: Host[] | undefined) => TableRow<Host>;
export declare const roleColumn: (canEditRole?: HostsTableActions['canEditRole'], onEditRole?: HostsTableActions['onEditRole']) => TableRow<Host>;
export declare const statusColumn: (AdditionalNTPSourcesDialogToggleComponent: React.FC, onEditHostname?: HostsTableActions['onEditHost']) => TableRow<Host>;
export declare const hardwareStatusColumn: (onEditHostname?: HostsTableActions['onEditHost']) => TableRow<Host>;
export declare const discoveredAtColumn: TableRow<Host>;
export declare const cpuCoresColumn: TableRow<Host>;
export declare const memoryColumn: TableRow<Host>;
export declare const disksColumn: TableRow<Host>;
export declare const countColumn: (cluster: Cluster) => TableRow<Host>;
export declare const networkingStatusColumn: (onEditHostname?: HostsTableActions['onEditHost']) => TableRow<Host>;
export declare const activeNICColumn: (cluster: Cluster) => TableRow<Host>;
export declare const ipv4Column: (cluster: Cluster) => TableRow<Host>;
export declare const ipv6Column: (cluster: Cluster) => TableRow<Host>;
export declare const macAddressColumn: (cluster: Cluster) => TableRow<Host>;
export declare const hostActionResolver: ({ onInstallHost, canInstallHost, onEditHost, canEditHost, onHostEnable, canEnable, onHostDisable, canDisable, onHostReset, canReset, onViewHostEvents, onDownloadHostLogs, canDownloadHostLogs, onDeleteHost, canDelete, onEditBMH, canEditBMH, }: HostsTableActions) => ActionsResolver<Host>;
