import * as React from 'react';
import { HostsNotShowingLinkProps } from '../clusterConfiguration/DiscoveryTroubleshootingModal';
import { Host } from '../../../common';
import { ActionsResolver, ExpandComponentProps, TableRow } from '../../../common/components/hosts/AITable';
import { WithTestID } from '../../types';
declare type HostsTableEmptyStateProps = {
    setDiscoveryHintModalOpen?: HostsNotShowingLinkProps['setDiscoveryHintModalOpen'];
};
export declare const HostsTableEmptyState: React.FC<HostsTableEmptyStateProps>;
export declare const DefaultExpandComponent: React.FC<ExpandComponentProps<Host>>;
declare type HostsTableProps = {
    hosts: Host[];
    skipDisabled?: boolean;
    content: TableRow<Host>[];
    actionResolver: ActionsResolver<Host>;
    children: React.ReactNode;
    onSelect?: (obj: Host, isSelected: boolean) => void;
    selectedIDs?: string[];
    ExpandComponent?: React.ComponentType<ExpandComponentProps<Host>>;
    className?: string;
};
declare const HostsTable: React.FC<HostsTableProps & WithTestID>;
export default HostsTable;
