import { Address4, Address6 } from 'ip-address';
import { Cluster, ClusterDefaultConfig } from '../../api';
import { HostDiscoveryValues, HostSubnets } from '../../types/clusters';
import { OpenshiftVersionOptionType } from '../../types/versions';
export declare const getSubnet: (cidr: string) => Address6 | Address4 | null;
export declare const getHostSubnets: (cluster: Cluster) => HostSubnets;
export declare const getSubnetFromMachineNetworkCidr: (machineNetworkCidr?: string | undefined) => string | undefined;
export declare const isAdvNetworkConf: (cluster: Cluster, defaultNetworkSettings: ClusterDefaultConfig) => boolean;
export declare const getHostDiscoveryInitialValues: (cluster: Cluster) => HostDiscoveryValues;
export declare const getSNOSupportLevel: (version?: OpenshiftVersionOptionType['version']) => "supported" | "dev-preview";
