"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.ChartLegendTooltipLabel = void 0;
const tslib_1 = require("tslib");
const React = tslib_1.__importStar(require("react"));
const hoist_non_react_statics_1 = tslib_1.__importDefault(require("hoist-non-react-statics"));
const defaults_1 = tslib_1.__importDefault(require("lodash/defaults"));
const victory_core_1 = require("victory-core");
const ChartLabel_1 = require("../ChartLabel");
const ChartTheme_1 = require("../ChartTheme");
const ChartLegendTooltipLabel = (_a) => {
    var { dx = 0, index = 0, legendData, legendLabelComponent = React.createElement(ChartLabel_1.ChartLabel, null), style, text, textAnchor = 'end', x, y } = _a, 
    // destructure last
    rest = tslib_1.__rest(_a, ["dx", "index", "legendData", "legendLabelComponent", "style", "text", "textAnchor", "x", "y"]);
    const getStyle = (styles) => {
        const applyDefaultStyle = (customStyle) => defaults_1.default(Object.assign({}, customStyle), {
            fill: ChartTheme_1.ChartLegendTooltipStyles.label.fill
        });
        return Array.isArray(styles) ? styles.map(applyDefaultStyle) : applyDefaultStyle(styles);
    };
    const getLegendLabelComponent = () => {
        const label = legendData && legendData.length ? legendData[index].name : undefined;
        return React.cloneElement(legendLabelComponent, {
            style: getStyle({}),
            text: label,
            textAnchor: 'start',
            x,
            y
        });
    };
    const getValueLabelComponent = () => {
        const _x = x + victory_core_1.Helpers.evaluateProp(dx);
        return React.createElement(ChartLabel_1.ChartLabel, Object.assign({ style: getStyle(style), text: text, textAnchor: textAnchor, x: _x, y: y }, rest));
    };
    const legendLabel = getLegendLabelComponent();
    const valueLabel = getValueLabelComponent();
    return (React.createElement(React.Fragment, null,
        legendLabel,
        valueLabel));
};
exports.ChartLegendTooltipLabel = ChartLegendTooltipLabel;
exports.ChartLegendTooltipLabel.displayName = 'ChartLegendTooltipLabel';
// Note: VictoryLabel.role must be hoisted
hoist_non_react_statics_1.default(exports.ChartLegendTooltipLabel, victory_core_1.VictoryLabel);
//# sourceMappingURL=ChartLegendTooltipLabel.js.map