import React from 'react';
import { AppsConfig } from '@scalprum/core';
export declare type ScalprumFeed = AppsConfig | (() => AppsConfig) | (() => Promise<AppsConfig>);
export interface ScalprumState<T = Record<string, unknown>> {
    initialized: boolean;
    config: AppsConfig;
    api?: T;
}
export interface ScalprumProviderProps<T = Record<string, unknown>> {
    config: ScalprumFeed;
    api?: T;
    children: React.ReactNode;
}
export declare function ScalprumProvider<T = Record<string, unknown>>({ config, children, api, }: ScalprumProviderProps): React.ReactElement | React.ReactElement;
