"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
var tslib_1 = require("tslib");
var apollo_link_1 = require("apollo-link");
var fast_json_stable_stringify_1 = tslib_1.__importDefault(require("fast-json-stable-stringify"));
var printer_1 = require("graphql/language/printer");
var apollo_utilities_1 = require("apollo-utilities");
var isEqual = require('lodash.isequal');
var MockLink = (function (_super) {
    tslib_1.__extends(MockLink, _super);
    function MockLink(mockedResponses, addTypename) {
        if (addTypename === void 0) { addTypename = true; }
        var _this = _super.call(this) || this;
        _this.addTypename = true;
        _this.mockedResponsesByKey = {};
        _this.addTypename = addTypename;
        if (mockedResponses)
            mockedResponses.forEach(function (mockedResponse) {
                _this.addMockedResponse(mockedResponse);
            });
        return _this;
    }
    MockLink.prototype.addMockedResponse = function (mockedResponse) {
        var normalizedMockedResponse = this.normalizeMockedResponse(mockedResponse);
        var key = requestToKey(normalizedMockedResponse.request, this.addTypename);
        var mockedResponses = this.mockedResponsesByKey[key];
        if (!mockedResponses) {
            mockedResponses = [];
            this.mockedResponsesByKey[key] = mockedResponses;
        }
        mockedResponses.push(normalizedMockedResponse);
    };
    MockLink.prototype.request = function (operation) {
        var key = requestToKey(operation, this.addTypename);
        var responseIndex;
        var response = (this.mockedResponsesByKey[key] || []).find(function (res, index) {
            var requestVariables = operation.variables || {};
            var mockedResponseVariables = res.request.variables || {};
            if (!isEqual(fast_json_stable_stringify_1.default(requestVariables), fast_json_stable_stringify_1.default(mockedResponseVariables))) {
                return false;
            }
            responseIndex = index;
            return true;
        });
        if (!response || typeof responseIndex === 'undefined') {
            throw new Error("No more mocked responses for the query: " + printer_1.print(operation.query) + ", variables: " + JSON.stringify(operation.variables));
        }
        this.mockedResponsesByKey[key].splice(responseIndex, 1);
        var result = response.result, error = response.error, delay = response.delay, newData = response.newData;
        if (newData) {
            response.result = newData();
            this.mockedResponsesByKey[key].push(response);
        }
        if (!result && !error) {
            throw new Error("Mocked response should contain either result or error: " + key);
        }
        return new apollo_link_1.Observable(function (observer) {
            var timer = setTimeout(function () {
                if (error) {
                    observer.error(error);
                }
                else {
                    if (result) {
                        observer.next(typeof result === 'function'
                            ? result()
                            : result);
                    }
                    observer.complete();
                }
            }, delay ? delay : 0);
            return function () {
                clearTimeout(timer);
            };
        });
    };
    MockLink.prototype.normalizeMockedResponse = function (mockedResponse) {
        var newMockedResponse = apollo_utilities_1.cloneDeep(mockedResponse);
        newMockedResponse.request.query =
            apollo_utilities_1.removeConnectionDirectiveFromDocument(newMockedResponse.request.query);
        var query = apollo_utilities_1.removeClientSetsFromDocument(newMockedResponse.request.query);
        if (query) {
            newMockedResponse.request.query = query;
        }
        return newMockedResponse;
    };
    return MockLink;
}(apollo_link_1.ApolloLink));
exports.MockLink = MockLink;
var MockSubscriptionLink = (function (_super) {
    tslib_1.__extends(MockSubscriptionLink, _super);
    function MockSubscriptionLink() {
        var _this = _super.call(this) || this;
        _this.unsubscribers = [];
        _this.setups = [];
        return _this;
    }
    MockSubscriptionLink.prototype.request = function (_req) {
        var _this = this;
        return new apollo_link_1.Observable(function (observer) {
            _this.setups.forEach(function (x) { return x(); });
            _this.observer = observer;
            return function () {
                _this.unsubscribers.forEach(function (x) { return x(); });
            };
        });
    };
    MockSubscriptionLink.prototype.simulateResult = function (result, complete) {
        var _this = this;
        if (complete === void 0) { complete = false; }
        setTimeout(function () {
            var observer = _this.observer;
            if (!observer)
                throw new Error('subscription torn down');
            if (complete && observer.complete)
                observer.complete();
            if (result.result && observer.next)
                observer.next(result.result);
            if (result.error && observer.error)
                observer.error(result.error);
        }, result.delay || 0);
    };
    MockSubscriptionLink.prototype.onSetup = function (listener) {
        this.setups = this.setups.concat([listener]);
    };
    MockSubscriptionLink.prototype.onUnsubscribe = function (listener) {
        this.unsubscribers = this.unsubscribers.concat([listener]);
    };
    return MockSubscriptionLink;
}(apollo_link_1.ApolloLink));
exports.MockSubscriptionLink = MockSubscriptionLink;
function requestToKey(request, addTypename) {
    var queryString = request.query &&
        printer_1.print(addTypename ? apollo_utilities_1.addTypenameToDocument(request.query) : request.query);
    var requestKey = { query: queryString };
    return JSON.stringify(requestKey);
}
function mockSingleLink() {
    var mockedResponses = [];
    for (var _i = 0; _i < arguments.length; _i++) {
        mockedResponses[_i] = arguments[_i];
    }
    var maybeTypename = mockedResponses[mockedResponses.length - 1];
    var mocks = mockedResponses.slice(0, mockedResponses.length - 1);
    if (typeof maybeTypename !== 'boolean') {
        mocks = mockedResponses;
        maybeTypename = true;
    }
    return new MockLink(mocks, maybeTypename);
}
exports.mockSingleLink = mockSingleLink;
function mockObservableLink() {
    return new MockSubscriptionLink();
}
exports.mockObservableLink = mockObservableLink;
//# sourceMappingURL=test-links.js.map