var __assign = (this && this.__assign) || function () {
    __assign = Object.assign || function(t) {
        for (var s, i = 1, n = arguments.length; i < n; i++) {
            s = arguments[i];
            for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p))
                t[p] = s[p];
        }
        return t;
    };
    return __assign.apply(this, arguments);
};
var _a, _b, _c;
import React, { useState, useRef, useEffect } from 'react';
import PropTypes from 'prop-types';
import classNames from 'classnames';
import { TextInput, MenuList, MenuItem, MenuGroup, Checkbox, Button, MenuToggle, Menu, MenuContent, Popper, Radio, TreeView, } from '@patternfly/react-core';
import { isChecked, calculateSelected, getGroupMenuItems, getMenuItems, convertTreeItem, mapTree, onTreeCheck } from './groupFilterConstants';
import groupType from './groupType';
import './group-filter.css';
var Group = function (_a) {
    var placeholder = _a.placeholder, onShowMore = _a.onShowMore, showMoreTitle = _a.showMoreTitle, showMoreOptions = _a.showMoreOptions, items = _a.items, filterBy = _a.filterBy, onFilter = _a.onFilter, className = _a.className, _b = _a.groups, groups = _b === void 0 ? [] : _b, onChange = _a.onChange, selected = _a.selected, isFilterable = _a.isFilterable;
    var _c = useState({}), stateSelected = _c[0], setStateSelected = _c[1];
    var _d = useState(''), searchString = _d[0], setSearchString = _d[1];
    var _e = useState(false), isOpen = _e[0], setIsOpen = _e[1];
    var toggleRef = useRef();
    var containerRef = useRef();
    var menuRef = useRef();
    useEffect(function () {
        setStateSelected(selected);
    }, [selected]);
    useEffect(function () {
        setSearchString(filterBy);
    }, [filterBy]);
    var handleMenuKeys = function (event) {
        if (!isOpen) {
            return;
        }
        if (menuRef.current.contains(event.target) || toggleRef.current.contains(event.target)) {
            if (event.key === 'Escape' || event.key === 'Enter') {
                setIsOpen(!isOpen);
                toggleRef.current.focus();
            }
        }
    };
    var handleClickOutside = function (event) {
        if (isOpen && !menuRef.current.contains(event.target)) {
            setIsOpen(false);
        }
    };
    useEffect(function () {
        window.addEventListener('keydown', handleMenuKeys);
        window.addEventListener('click', handleClickOutside);
        return function () {
            window.removeEventListener('keydown', handleMenuKeys);
            window.removeEventListener('click', handleClickOutside);
        };
    }, [isOpen, menuRef]);
    var onToggleClick = function (ev) {
        ev.stopPropagation();
        ev.persist();
        setIsOpen(!isOpen);
    };
    var menuItems = getMenuItems(items === null || items === void 0 ? void 0 : items.map(function (item) { return (item.type === groupType.treeView ? convertTreeItem(item) : item); }), onChange, calculateSelected(selected));
    var groupMenuItems = getGroupMenuItems(groups, onChange, calculateSelected(selected));
    var renderItem = function (item, key, type, groupKey) { return (React.createElement(MenuItem, { itemId: key, key: "".concat(item.value, "-").concat(key, "-item"), className: item === null || item === void 0 ? void 0 : item.className, onClick: item.onClick && (type || item.type) === groupType.checkbox
            ? function (e) {
                item.onClick();
                e.preventDefault();
            }
            : undefined }, (type || item.type) === groupType.treeView ? (React.createElement(TreeView, { data: [mapTree(item, groupKey, stateSelected, selected)], onCheck: function (e, value) { return onTreeCheck(e, value, [item]); }, hasChecks: true })) : (type || item.type) === groupType.checkbox ? (React.createElement(Checkbox, __assign({}, item, { label: item === null || item === void 0 ? void 0 : item.label, isChecked: (item === null || item === void 0 ? void 0 : item.isChecked) || isChecked(groupKey, (item === null || item === void 0 ? void 0 : item.value) || key, item === null || item === void 0 ? void 0 : item.id, item === null || item === void 0 ? void 0 : item.tagValue, stateSelected, selected) || false, onChange: function (value, event) {
            var _a;
            (_a = item === null || item === void 0 ? void 0 : item.onChange) === null || _a === void 0 ? void 0 : _a.call(item, value, event);
        }, onClick: item.onClick
            ? function (e) {
                item.onClick();
                e.stopPropagation();
            }
            : undefined, name: (item === null || item === void 0 ? void 0 : item.name) || (item === null || item === void 0 ? void 0 : item.value) || "".concat(groupKey, "-").concat(key), id: (item === null || item === void 0 ? void 0 : item.id) || (item === null || item === void 0 ? void 0 : item.value) || "".concat(groupKey, "-").concat(key) }))) : (type || item.type) === groupType.radio ? (React.createElement(Radio, __assign({}, item, { isChecked: (item === null || item === void 0 ? void 0 : item.isChecked) || isChecked((groups === null || groups === void 0 ? void 0 : groups.value) || groupKey, (item === null || item === void 0 ? void 0 : item.value) || key, item === null || item === void 0 ? void 0 : item.id, item === null || item === void 0 ? void 0 : item.tagValue, stateSelected, selected) || false, onChange: function (value, event) {
            var _a;
            (_a = item === null || item === void 0 ? void 0 : item.onChange) === null || _a === void 0 ? void 0 : _a.call(item, value, event);
        }, value: (item === null || item === void 0 ? void 0 : item.value) || key, name: (item === null || item === void 0 ? void 0 : item.name) || (item === null || item === void 0 ? void 0 : item.value) || "".concat(groupKey, "-").concat(key), label: (item === null || item === void 0 ? void 0 : item.label) || '', id: (item === null || item === void 0 ? void 0 : item.id) || (item === null || item === void 0 ? void 0 : item.value) || "".concat(groupKey, "-").concat(key) }))) : (type || item.type) === groupType.button ? (React.createElement(Button, __assign({}, item, { className: "pf-c-select__option-button ".concat((item === null || item === void 0 ? void 0 : item.className) || ''), variant: item === null || item === void 0 ? void 0 : item.variant, onClick: item.onClick }), item === null || item === void 0 ? void 0 : item.label)) : ((item === null || item === void 0 ? void 0 : item.label) || ''))); };
    var renderItems = function (items, type, groupKey) {
        if (groupKey === void 0) { groupKey = ''; }
        return items.map(function (item, key) {
            return (type || item.type) === groupType.treeView ? (React.createElement("div", { key: "".concat(item.value, "-").concat(key, "-item"), className: "ins-c-tree-view" }, renderItem(item, key, type, groupKey))) : (renderItem(item, key, type, groupKey));
        });
    };
    return (React.createElement("div", { ref: containerRef },
        React.createElement(Popper, { appendTo: containerRef.current, trigger: React.createElement(MenuToggle, { "aria-label": "Group filter", ref: toggleRef, onClick: onToggleClick, isExpanded: isOpen, className: className }, isFilterable || onFilter ? (React.createElement(TextInput, { "aria-label": "input with dropdown and clear button", placeholder: placeholder, value: searchString, tabIndex: 0, onChange: function (value) {
                    setSearchString(value);
                    onFilter === null || onFilter === void 0 ? void 0 : onFilter(value);
                }, type: "search" })) : (placeholder)), popper: React.createElement(Menu, { ref: menuRef, className: classNames('ins-c-menu__scrollable', className, { 'pf-m-expanded': isOpen }) },
                React.createElement(MenuContent, null,
                    React.createElement(MenuList, { "aria-label": "Group filter" },
                        menuItems.length > 0 && React.createElement(MenuGroup, null, renderItems(menuItems)),
                        groupMenuItems.map(function (group, groupKey) { return (React.createElement(MenuGroup, { label: group.groupSelectable ? undefined : group.label, key: "".concat(group.label, "-").concat(groupKey, "-group") }, renderItems(group.items, group.type, group.value, group))); }),
                        onShowMore ? (React.createElement(MenuItem, __assign({ itemId: "loader", className: "ins-c-menu__show--more" }, showMoreOptions, { onClick: function (e) { return onShowMore(e); } }), showMoreTitle)) : (React.createElement("span", { hidden: true, value: "" }))))), isVisible: isOpen })));
};
Group.propTypes = {
    placeholder: PropTypes.string,
    onShowMore: PropTypes.func,
    showMoreTitle: PropTypes.node,
    onShowMoreTitle: PropTypes.func,
    showMoreOptions: PropTypes.any,
    items: PropTypes.arrayOf(PropTypes.shape({
        id: PropTypes.string,
        value: PropTypes.string,
        label: PropTypes.node,
    })),
    className: PropTypes.string,
    selected: PropTypes.shape((_a = {},
        _a[PropTypes.string] = PropTypes.shape((_b = {},
            _b[PropTypes.string] = PropTypes.shape((_c = {},
                _c[PropTypes.string] = PropTypes.any,
                _c)),
            _b)),
        _a)),
    isFilterable: PropTypes.bool,
    filterBy: PropTypes.string,
    onFilter: PropTypes.func,
    groups: PropTypes.arrayOf(PropTypes.shape({
        groupSelectable: PropTypes.bool,
        type: PropTypes.oneOf(Object.keys(groupType)),
        value: PropTypes.string,
        label: PropTypes.node,
        items: PropTypes.arrayOf(PropTypes.shape({
            id: PropTypes.string,
            tagKey: PropTypes.string,
        })),
    })),
    onChange: PropTypes.func.isRequired,
    selectedTags: PropTypes.shape({}),
};
export default Group;
//# sourceMappingURL=GroupFilter.js.map