"use strict";
var __assign = (this && this.__assign) || function () {
    __assign = Object.assign || function(t) {
        for (var s, i = 1, n = arguments.length; i < n; i++) {
            s = arguments[i];
            for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p))
                t[p] = s[p];
        }
        return t;
    };
    return __assign.apply(this, arguments);
};
var __rest = (this && this.__rest) || function (s, e) {
    var t = {};
    for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p) && e.indexOf(p) < 0)
        t[p] = s[p];
    if (s != null && typeof Object.getOwnPropertySymbols === "function")
        for (var i = 0, p = Object.getOwnPropertySymbols(s); i < p.length; i++) {
            if (e.indexOf(p[i]) < 0 && Object.prototype.propertyIsEnumerable.call(s, p[i]))
                t[p[i]] = s[p[i]];
        }
    return t;
};
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
var prop_types_1 = __importDefault(require("prop-types"));
var react_1 = __importDefault(require("react"));
var classnames_1 = __importDefault(require("classnames"));
var react_core_1 = require("@patternfly/react-core/");
var checkTypes = ['checkbox', 'radio'];
var Input = function (_a) {
    var _b = _a.type, type = _b === void 0 ? 'text' : _b, _c = _a.ariaLabel, ariaLabel = _c === void 0 ? type : _c, className = _a.className, ouiaId = _a.ouiaId, ouiaSafe = _a.ouiaSafe, props = __rest(_a, ["type", "ariaLabel", "className", "ouiaId", "ouiaSafe"]);
    var classes = checkTypes.indexOf(type) !== -1 ? 'pf-c-check' : 'pf-c-form-control';
    var ouiaComponentType = 'RHI/Input';
    var ouiaFinalId = (0, react_core_1.useOUIAId)(ouiaComponentType, ouiaId, ouiaSafe);
    return (react_1.default.createElement("input", __assign({}, props, { "data-ouia-component-type": ouiaComponentType, "data-ouia-component-id": ouiaFinalId, "data-ouia-safe": ouiaSafe, type: type, "aria-label": ariaLabel, className: (0, classnames_1.default)(classes, className) })));
};
Input.propTypes = {
    type: prop_types_1.default.string,
    className: prop_types_1.default.string,
    ariaLabel: prop_types_1.default.string,
    ouiaId: prop_types_1.default.string,
    ouiaSafe: prop_types_1.default.bool,
};
Input.defaultProps = {
    ouiaSafe: true,
};
exports.default = Input;
//# sourceMappingURL=Input.js.map