"use strict";
var __assign = (this && this.__assign) || function () {
    __assign = Object.assign || function(t) {
        for (var s, i = 1, n = arguments.length; i < n; i++) {
            s = arguments[i];
            for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p))
                t[p] = s[p];
        }
        return t;
    };
    return __assign.apply(this, arguments);
};
var __rest = (this && this.__rest) || function (s, e) {
    var t = {};
    for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p) && e.indexOf(p) < 0)
        t[p] = s[p];
    if (s != null && typeof Object.getOwnPropertySymbols === "function")
        for (var i = 0, p = Object.getOwnPropertySymbols(s); i < p.length; i++) {
            if (e.indexOf(p[i]) < 0 && Object.prototype.propertyIsEnumerable.call(s, p[i]))
                t[p[i]] = s[p[i]];
        }
    return t;
};
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
var react_1 = __importDefault(require("react"));
var react_icons_1 = require("@patternfly/react-icons/");
var DefaultErrorMessage_1 = __importDefault(require("./DefaultErrorMessage"));
var react_core_1 = require("@patternfly/react-core");
require("./error-state.css");
var ErrorState = function (_a) {
    var _b = _a.errorTitle, errorTitle = _b === void 0 ? 'Something went wrong' : _b, errorDescription = _a.errorDescription, props = __rest(_a, ["errorTitle", "errorDescription"]);
    return (react_1.default.createElement(react_core_1.EmptyState, __assign({ variant: react_core_1.EmptyStateVariant.large }, props, { className: "ins-c-error-state" }),
        react_1.default.createElement(react_core_1.EmptyStateIcon, { icon: react_icons_1.ExclamationCircleIcon }),
        react_1.default.createElement(react_core_1.Title, { headingLevel: "h4", size: "lg" }, errorTitle),
        react_1.default.createElement(react_core_1.EmptyStateBody, null,
            react_1.default.createElement(react_core_1.Stack, null,
                !errorDescription && react_1.default.createElement(react_core_1.StackItem, null, "There was a problem processing the request. Please try again."),
                react_1.default.createElement(react_core_1.StackItem, null, errorDescription || react_1.default.createElement(DefaultErrorMessage_1.default, null)))),
        document.referrer ? (react_1.default.createElement(react_core_1.Button, { variant: "primary", onClick: function () { return history.back(); } }, "Return to last page")) : (react_1.default.createElement(react_core_1.Button, { variant: "primary", component: "a", href: ".", target: "_blank", rel: "noopener noreferrer" }, "Go to home page"))));
};
exports.default = ErrorState;
//# sourceMappingURL=ErrorState.js.map