"use strict";
var __assign = (this && this.__assign) || function () {
    __assign = Object.assign || function(t) {
        for (var s, i = 1, n = arguments.length; i < n; i++) {
            s = arguments[i];
            for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p))
                t[p] = s[p];
        }
        return t;
    };
    return __assign.apply(this, arguments);
};
var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    Object.defineProperty(o, k2, { enumerable: true, get: function() { return m[k]; } });
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __setModuleDefault = (this && this.__setModuleDefault) || (Object.create ? (function(o, v) {
    Object.defineProperty(o, "default", { enumerable: true, value: v });
}) : function(o, v) {
    o["default"] = v;
});
var __importStar = (this && this.__importStar) || function (mod) {
    if (mod && mod.__esModule) return mod;
    var result = {};
    if (mod != null) for (var k in mod) if (k !== "default" && Object.prototype.hasOwnProperty.call(mod, k)) __createBinding(result, mod, k);
    __setModuleDefault(result, mod);
    return result;
};
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
var _a, _b, _c;
Object.defineProperty(exports, "__esModule", { value: true });
var react_1 = __importStar(require("react"));
var prop_types_1 = __importDefault(require("prop-types"));
var classnames_1 = __importDefault(require("classnames"));
var react_core_1 = require("@patternfly/react-core");
var groupFilterConstants_1 = require("./groupFilterConstants");
var groupType_1 = __importDefault(require("./groupType"));
require("./group-filter.css");
var Group = function (_a) {
    var placeholder = _a.placeholder, onShowMore = _a.onShowMore, showMoreTitle = _a.showMoreTitle, showMoreOptions = _a.showMoreOptions, items = _a.items, filterBy = _a.filterBy, onFilter = _a.onFilter, className = _a.className, _b = _a.groups, groups = _b === void 0 ? [] : _b, onChange = _a.onChange, selected = _a.selected, isFilterable = _a.isFilterable;
    var _c = (0, react_1.useState)({}), stateSelected = _c[0], setStateSelected = _c[1];
    var _d = (0, react_1.useState)(''), searchString = _d[0], setSearchString = _d[1];
    var _e = (0, react_1.useState)(false), isOpen = _e[0], setIsOpen = _e[1];
    var toggleRef = (0, react_1.useRef)();
    var containerRef = (0, react_1.useRef)();
    var menuRef = (0, react_1.useRef)();
    (0, react_1.useEffect)(function () {
        setStateSelected(selected);
    }, [selected]);
    (0, react_1.useEffect)(function () {
        setSearchString(filterBy);
    }, [filterBy]);
    var handleMenuKeys = function (event) {
        if (!isOpen) {
            return;
        }
        if (menuRef.current.contains(event.target) || toggleRef.current.contains(event.target)) {
            if (event.key === 'Escape' || event.key === 'Enter') {
                setIsOpen(!isOpen);
                toggleRef.current.focus();
            }
        }
    };
    var handleClickOutside = function (event) {
        if (isOpen && !menuRef.current.contains(event.target)) {
            setIsOpen(false);
        }
    };
    (0, react_1.useEffect)(function () {
        window.addEventListener('keydown', handleMenuKeys);
        window.addEventListener('click', handleClickOutside);
        return function () {
            window.removeEventListener('keydown', handleMenuKeys);
            window.removeEventListener('click', handleClickOutside);
        };
    }, [isOpen, menuRef]);
    var onToggleClick = function (ev) {
        ev.stopPropagation();
        ev.persist();
        setIsOpen(!isOpen);
    };
    var menuItems = (0, groupFilterConstants_1.getMenuItems)(items === null || items === void 0 ? void 0 : items.map(function (item) { return (item.type === groupType_1.default.treeView ? (0, groupFilterConstants_1.convertTreeItem)(item) : item); }), onChange, (0, groupFilterConstants_1.calculateSelected)(selected));
    var groupMenuItems = (0, groupFilterConstants_1.getGroupMenuItems)(groups, onChange, (0, groupFilterConstants_1.calculateSelected)(selected));
    var renderItem = function (item, key, type, groupKey) { return (react_1.default.createElement(react_core_1.MenuItem, { itemId: key, key: "".concat(item.value, "-").concat(key, "-item"), className: item === null || item === void 0 ? void 0 : item.className, onClick: item.onClick && (type || item.type) === groupType_1.default.checkbox
            ? function (e) {
                item.onClick();
                e.preventDefault();
            }
            : undefined }, (type || item.type) === groupType_1.default.treeView ? (react_1.default.createElement(react_core_1.TreeView, { data: [(0, groupFilterConstants_1.mapTree)(item, groupKey, stateSelected, selected)], onCheck: function (e, value) { return (0, groupFilterConstants_1.onTreeCheck)(e, value, [item]); }, hasChecks: true })) : (type || item.type) === groupType_1.default.checkbox ? (react_1.default.createElement(react_core_1.Checkbox, __assign({}, item, { label: item === null || item === void 0 ? void 0 : item.label, isChecked: (item === null || item === void 0 ? void 0 : item.isChecked) || (0, groupFilterConstants_1.isChecked)(groupKey, (item === null || item === void 0 ? void 0 : item.value) || key, item === null || item === void 0 ? void 0 : item.id, item === null || item === void 0 ? void 0 : item.tagValue, stateSelected, selected) || false, onChange: function (value, event) {
            var _a;
            (_a = item === null || item === void 0 ? void 0 : item.onChange) === null || _a === void 0 ? void 0 : _a.call(item, value, event);
        }, onClick: item.onClick
            ? function (e) {
                item.onClick();
                e.stopPropagation();
            }
            : undefined, name: (item === null || item === void 0 ? void 0 : item.name) || (item === null || item === void 0 ? void 0 : item.value) || "".concat(groupKey, "-").concat(key), id: (item === null || item === void 0 ? void 0 : item.id) || (item === null || item === void 0 ? void 0 : item.value) || "".concat(groupKey, "-").concat(key) }))) : (type || item.type) === groupType_1.default.radio ? (react_1.default.createElement(react_core_1.Radio, __assign({}, item, { isChecked: (item === null || item === void 0 ? void 0 : item.isChecked) || (0, groupFilterConstants_1.isChecked)((groups === null || groups === void 0 ? void 0 : groups.value) || groupKey, (item === null || item === void 0 ? void 0 : item.value) || key, item === null || item === void 0 ? void 0 : item.id, item === null || item === void 0 ? void 0 : item.tagValue, stateSelected, selected) || false, onChange: function (value, event) {
            var _a;
            (_a = item === null || item === void 0 ? void 0 : item.onChange) === null || _a === void 0 ? void 0 : _a.call(item, value, event);
        }, value: (item === null || item === void 0 ? void 0 : item.value) || key, name: (item === null || item === void 0 ? void 0 : item.name) || (item === null || item === void 0 ? void 0 : item.value) || "".concat(groupKey, "-").concat(key), label: (item === null || item === void 0 ? void 0 : item.label) || '', id: (item === null || item === void 0 ? void 0 : item.id) || (item === null || item === void 0 ? void 0 : item.value) || "".concat(groupKey, "-").concat(key) }))) : (type || item.type) === groupType_1.default.button ? (react_1.default.createElement(react_core_1.Button, __assign({}, item, { className: "pf-c-select__option-button ".concat((item === null || item === void 0 ? void 0 : item.className) || ''), variant: item === null || item === void 0 ? void 0 : item.variant, onClick: item.onClick }), item === null || item === void 0 ? void 0 : item.label)) : ((item === null || item === void 0 ? void 0 : item.label) || ''))); };
    var renderItems = function (items, type, groupKey) {
        if (groupKey === void 0) { groupKey = ''; }
        return items.map(function (item, key) {
            return (type || item.type) === groupType_1.default.treeView ? (react_1.default.createElement("div", { key: "".concat(item.value, "-").concat(key, "-item"), className: "ins-c-tree-view" }, renderItem(item, key, type, groupKey))) : (renderItem(item, key, type, groupKey));
        });
    };
    return (react_1.default.createElement("div", { ref: containerRef },
        react_1.default.createElement(react_core_1.Popper, { appendTo: containerRef.current, trigger: react_1.default.createElement(react_core_1.MenuToggle, { "aria-label": "Group filter", ref: toggleRef, onClick: onToggleClick, isExpanded: isOpen, className: className }, isFilterable || onFilter ? (react_1.default.createElement(react_core_1.TextInput, { "aria-label": "input with dropdown and clear button", placeholder: placeholder, value: searchString, tabIndex: 0, onChange: function (value) {
                    setSearchString(value);
                    onFilter === null || onFilter === void 0 ? void 0 : onFilter(value);
                }, type: "search" })) : (placeholder)), popper: react_1.default.createElement(react_core_1.Menu, { ref: menuRef, className: (0, classnames_1.default)('ins-c-menu__scrollable', className, { 'pf-m-expanded': isOpen }) },
                react_1.default.createElement(react_core_1.MenuContent, null,
                    react_1.default.createElement(react_core_1.MenuList, { "aria-label": "Group filter" },
                        menuItems.length > 0 && react_1.default.createElement(react_core_1.MenuGroup, null, renderItems(menuItems)),
                        groupMenuItems.map(function (group, groupKey) { return (react_1.default.createElement(react_core_1.MenuGroup, { label: group.groupSelectable ? undefined : group.label, key: "".concat(group.label, "-").concat(groupKey, "-group") }, renderItems(group.items, group.type, group.value, group))); }),
                        onShowMore ? (react_1.default.createElement(react_core_1.MenuItem, __assign({ itemId: "loader", className: "ins-c-menu__show--more" }, showMoreOptions, { onClick: function (e) { return onShowMore(e); } }), showMoreTitle)) : (react_1.default.createElement("span", { hidden: true, value: "" }))))), isVisible: isOpen })));
};
Group.propTypes = {
    placeholder: prop_types_1.default.string,
    onShowMore: prop_types_1.default.func,
    showMoreTitle: prop_types_1.default.node,
    onShowMoreTitle: prop_types_1.default.func,
    showMoreOptions: prop_types_1.default.any,
    items: prop_types_1.default.arrayOf(prop_types_1.default.shape({
        id: prop_types_1.default.string,
        value: prop_types_1.default.string,
        label: prop_types_1.default.node,
    })),
    className: prop_types_1.default.string,
    selected: prop_types_1.default.shape((_a = {},
        _a[prop_types_1.default.string] = prop_types_1.default.shape((_b = {},
            _b[prop_types_1.default.string] = prop_types_1.default.shape((_c = {},
                _c[prop_types_1.default.string] = prop_types_1.default.any,
                _c)),
            _b)),
        _a)),
    isFilterable: prop_types_1.default.bool,
    filterBy: prop_types_1.default.string,
    onFilter: prop_types_1.default.func,
    groups: prop_types_1.default.arrayOf(prop_types_1.default.shape({
        groupSelectable: prop_types_1.default.bool,
        type: prop_types_1.default.oneOf(Object.keys(groupType_1.default)),
        value: prop_types_1.default.string,
        label: prop_types_1.default.node,
        items: prop_types_1.default.arrayOf(prop_types_1.default.shape({
            id: prop_types_1.default.string,
            tagKey: prop_types_1.default.string,
        })),
    })),
    onChange: prop_types_1.default.func.isRequired,
    selectedTags: prop_types_1.default.shape({}),
};
exports.default = Group;
//# sourceMappingURL=GroupFilter.js.map