import _defineProperty from "@babel/runtime/helpers/defineProperty";

function ownKeys(object, enumerableOnly) { var keys = Object.keys(object); if (Object.getOwnPropertySymbols) { var symbols = Object.getOwnPropertySymbols(object); if (enumerableOnly) { symbols = symbols.filter(function (sym) { return Object.getOwnPropertyDescriptor(object, sym).enumerable; }); } keys.push.apply(keys, symbols); } return keys; }

function _objectSpread(target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i] != null ? arguments[i] : {}; if (i % 2) { ownKeys(Object(source), true).forEach(function (key) { _defineProperty(target, key, source[key]); }); } else if (Object.getOwnPropertyDescriptors) { Object.defineProperties(target, Object.getOwnPropertyDescriptors(source)); } else { ownKeys(Object(source)).forEach(function (key) { Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key)); }); } } return target; }

import React from 'react';
import propTypes from 'prop-types';
import doT from 'dot';
import marked from 'marked';
import sanitizeHtml from 'sanitize-html';

marked.Renderer.prototype.link = function (href, title, text) {
  return "<a href=\"".concat(href, "\" rel=\"noopener noreferrer\" target=\"_blank\" class=\"ins-c-rule__link-in-description\">").concat(text, "</a>");
};

marked.setOptions({
  renderer: new marked.Renderer()
});

var Markdown = function Markdown(_ref) {
  var template = _ref.template,
      definitions = _ref.definitions;

  var DOT_SETTINGS = _objectSpread(_objectSpread({}, doT.templateSettings), {}, {
    varname: ['pydata'],
    strip: false
  });

  var sanitizeOptions = {
    allowedAttributes: _objectSpread(_objectSpread({}, sanitizeHtml.defaults.allowedAttributes), {}, {
      '*': ['style']
    }),
    transformTags: {
      ul: function ul() {
        return {
          tagName: 'ul',
          attribs: {
            "class": 'pf-c-list'
          }
        };
      }
    },
    textFilter: function textFilter(text) {
      return text.replace(/&amp;/g, '&').replace(/&gt;/g, '>').replace(/&lt;/g, '<');
    }
  };
  var externalLinkIcon = '<i class="fas fa-external-link-alt"></i>';

  try {
    var compiledDot = definitions ? doT.template(template, DOT_SETTINGS)(definitions) : template;
    var compiledMd = marked(sanitizeHtml(compiledDot, sanitizeOptions));
    return /*#__PURE__*/React.createElement("div", {
      className: "ins-c-rule__markdown",
      dangerouslySetInnerHTML: {
        __html: compiledMd.replace(/<ul>/gim, "<ul class=\"pf-c-list\" style=\"font-size: inherit\">").replace(/<a>/gim, "<a rel=\"noopener noreferrer\" target=\"_blank\">").replace(/<\/a>/gim, " ".concat(externalLinkIcon, "</a>"))
      }
    });
  } catch (error) {
    console.warn(error, definitions, template); // eslint-disable-line no-console

    return /*#__PURE__*/React.createElement(React.Fragment, null, ' ', "Ouch. We were unable to correctly render this text, instead please enjoy the raw data.", /*#__PURE__*/React.createElement("pre", null, /*#__PURE__*/React.createElement("code", null, template)));
  }
};

Markdown.propTypes = {
  template: propTypes.string.isRequired,
  definitions: propTypes.object
};
export default Markdown;